/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;

public enum PartitionRole
{
    LEADER((short)0),

    FOLLOWER((short)1),

    INACTIVE((short)2),

    /**
     * To be used to represent an unknown value from a later version.
     */
    SBE_UNKNOWN((short)255),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    PartitionRole(final short value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public short value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static PartitionRole get(final short value)
    {
        switch (value)
        {
            case 0: return LEADER;
            case 1: return FOLLOWER;
            case 2: return INACTIVE;
            case 255: return NULL_VAL;
        }

        return SBE_UNKNOWN;
    }
}
