package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IncidentRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIncidentRecordValue.builder()}.
 */
@Generated(from = "IncidentRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableIncidentRecordValue
    implements IncidentRecordValue {
  private final ErrorType errorType;
  private final String errorMessage;
  private final String bpmnProcessId;
  private final long processDefinitionKey;
  private final long processInstanceKey;
  private final String elementId;
  private final long elementInstanceKey;
  private final long jobKey;
  private final long variableScopeKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableIncidentRecordValue(
      ErrorType errorType,
      String errorMessage,
      String bpmnProcessId,
      long processDefinitionKey,
      long processInstanceKey,
      String elementId,
      long elementInstanceKey,
      long jobKey,
      long variableScopeKey) {
    this.errorType = errorType;
    this.errorMessage = errorMessage;
    this.bpmnProcessId = bpmnProcessId;
    this.processDefinitionKey = processDefinitionKey;
    this.processInstanceKey = processInstanceKey;
    this.elementId = elementId;
    this.elementInstanceKey = elementInstanceKey;
    this.jobKey = jobKey;
    this.variableScopeKey = variableScopeKey;
  }

  /**
   * @return the type of error this incident is caused by. Can be <code>UNKNOWN</code> if the
   *     incident record is part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public ErrorType getErrorType() {
    return errorType;
  }

  /**
   * @return the description of the error this incident is caused by. Can be empty if the incident
   *     record is part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public String getErrorMessage() {
    return errorMessage;
  }

  /**
   * @return the BPMN process id this incident belongs to. Can be empty if the incident record is
   *     part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the key of the process this incident belongs to. Can be <code>-1</code> if the incident
   *     record is part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the key of the process instance this incident belongs to. Can be <code>-1</code> if the
   *     incident record is part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the id of the element this incident belongs to. Can be empty if incident record is part
   *     of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return the key of the element instance this incident belongs to. Can be <code>-1</code> if the
   *     incident record is part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the key of the job this incident belongs to. Can be <code>-1</code> if the incident
   *     belongs to no job or the incident record is part of a {@link IncidentIntent#RESOLVE}
   *     command.
   */
  @Override
  public long getJobKey() {
    return jobKey;
  }

  /**
   * @return the key of the variable scope on which the variables need to be updated. Can be <code>
   *     -1</code> if the incident record is part of a {@link IncidentIntent#RESOLVE} command.
   */
  @Override
  public long getVariableScopeKey() {
    return variableScopeKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getErrorType() errorType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withErrorType(ErrorType value) {
    if (this.errorType == value) return this;
    return new ImmutableIncidentRecordValue(
        value,
        this.errorMessage,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getErrorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withErrorMessage(String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        value,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        value,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        this.bpmnProcessId,
        value,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        this.bpmnProcessId,
        this.processDefinitionKey,
        value,
        this.elementId,
        this.elementInstanceKey,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        value,
        this.elementInstanceKey,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        value,
        this.jobKey,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getJobKey() jobKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withJobKey(long value) {
    if (this.jobKey == value) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        value,
        this.variableScopeKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncidentRecordValue#getVariableScopeKey() variableScopeKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for variableScopeKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIncidentRecordValue withVariableScopeKey(long value) {
    if (this.variableScopeKey == value) return this;
    return new ImmutableIncidentRecordValue(
        this.errorType,
        this.errorMessage,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.jobKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIncidentRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIncidentRecordValue
        && equalTo(0, (ImmutableIncidentRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableIncidentRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(errorType, another.errorType)
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && processDefinitionKey == another.processDefinitionKey
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(elementId, another.elementId)
        && elementInstanceKey == another.elementInstanceKey
        && jobKey == another.jobKey
        && variableScopeKey == another.variableScopeKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code errorType}, {@code errorMessage}, {@code bpmnProcessId}, {@code processDefinitionKey}, {@code processInstanceKey}, {@code elementId}, {@code elementInstanceKey}, {@code jobKey}, {@code variableScopeKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(errorType);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Long.hashCode(jobKey);
    h += (h << 5) + Long.hashCode(variableScopeKey);
    return h;
  }

  /**
   * Prints the immutable value {@code IncidentRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IncidentRecordValue{"
        + "errorType=" + errorType
        + ", errorMessage=" + errorMessage
        + ", bpmnProcessId=" + bpmnProcessId
        + ", processDefinitionKey=" + processDefinitionKey
        + ", processInstanceKey=" + processInstanceKey
        + ", elementId=" + elementId
        + ", elementInstanceKey=" + elementInstanceKey
        + ", jobKey=" + jobKey
        + ", variableScopeKey=" + variableScopeKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link IncidentRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IncidentRecordValue instance
   */
  public static ImmutableIncidentRecordValue copyOf(IncidentRecordValue instance) {
    if (instance instanceof ImmutableIncidentRecordValue) {
      return (ImmutableIncidentRecordValue) instance;
    }
    return ImmutableIncidentRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIncidentRecordValue ImmutableIncidentRecordValue}.
   * <pre>
   * ImmutableIncidentRecordValue.builder()
   *    .withErrorType(io.camunda.zeebe.protocol.record.value.ErrorType | null) // nullable {@link IncidentRecordValue#getErrorType() errorType}
   *    .withErrorMessage(String | null) // nullable {@link IncidentRecordValue#getErrorMessage() errorMessage}
   *    .withBpmnProcessId(String | null) // nullable {@link IncidentRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withProcessDefinitionKey(long) // optional {@link IncidentRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withProcessInstanceKey(long) // optional {@link IncidentRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withElementId(String | null) // nullable {@link IncidentRecordValue#getElementId() elementId}
   *    .withElementInstanceKey(long) // optional {@link IncidentRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withJobKey(long) // optional {@link IncidentRecordValue#getJobKey() jobKey}
   *    .withVariableScopeKey(long) // optional {@link IncidentRecordValue#getVariableScopeKey() variableScopeKey}
   *    .build();
   * </pre>
   * @return A new ImmutableIncidentRecordValue builder
   */
  public static ImmutableIncidentRecordValue.Builder builder() {
    return new ImmutableIncidentRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIncidentRecordValue ImmutableIncidentRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IncidentRecordValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable ErrorType errorType;
    private @Nullable String errorMessage;
    private @Nullable String bpmnProcessId;
    private long processDefinitionKey;
    private long processInstanceKey;
    private @Nullable String elementId;
    private long elementInstanceKey;
    private long jobKey;
    private long variableScopeKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.IncidentRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IncidentRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof IncidentRecordValue) {
        IncidentRecordValue instance = (IncidentRecordValue) object;
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        withVariableScopeKey(instance.getVariableScopeKey());
        withElementInstanceKey(instance.getElementInstanceKey());
        ErrorType errorTypeValue = instance.getErrorType();
        if (errorTypeValue != null) {
          withErrorType(errorTypeValue);
        }
        String errorMessageValue = instance.getErrorMessage();
        if (errorMessageValue != null) {
          withErrorMessage(errorMessageValue);
        }
        withJobKey(instance.getJobKey());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getErrorType() errorType} attribute.
     * @param errorType The value for errorType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withErrorType(ErrorType errorType) {
      this.errorType = errorType;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withErrorMessage(String errorMessage) {
      this.errorMessage = errorMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getJobKey() jobKey} attribute.
     * @param jobKey The value for jobKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withJobKey(long jobKey) {
      this.jobKey = jobKey;
      return this;
    }

    /**
     * Initializes the value for the {@link IncidentRecordValue#getVariableScopeKey() variableScopeKey} attribute.
     * @param variableScopeKey The value for variableScopeKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariableScopeKey(long variableScopeKey) {
      this.variableScopeKey = variableScopeKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.errorType = null;
      this.errorMessage = null;
      this.bpmnProcessId = null;
      this.processDefinitionKey = 0;
      this.processInstanceKey = 0;
      this.elementId = null;
      this.elementInstanceKey = 0;
      this.jobKey = 0;
      this.variableScopeKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIncidentRecordValue ImmutableIncidentRecordValue}.
     * @return An immutable instance of IncidentRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIncidentRecordValue build() {
      return new ImmutableIncidentRecordValue(
          errorType,
          errorMessage,
          bpmnProcessId,
          processDefinitionKey,
          processInstanceKey,
          elementId,
          elementInstanceKey,
          jobKey,
          variableScopeKey);
    }



  }



}
