package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceResultRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceResultRecordValue.builder()}.
 */
@Generated(from = "ProcessInstanceResultRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProcessInstanceResultRecordValue
    implements ProcessInstanceResultRecordValue {
  private final Map<String, Object> variables;
  private final String bpmnProcessId;
  private final int version;
  private final long processDefinitionKey;
  private final long processInstanceKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceResultRecordValue(
      Map<String, Object> variables,
      String bpmnProcessId,
      int version,
      long processDefinitionKey,
      long processInstanceKey) {
    this.variables = variables;
    this.bpmnProcessId = bpmnProcessId;
    this.version = version;
    this.processDefinitionKey = processDefinitionKey;
    this.processInstanceKey = processInstanceKey;
  }

  /**
   *@return the variables of this record. Can be empty. 
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   *@return the BPMN process id this process instance belongs to. 
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   *@return the version of the deployed process this instance belongs to. 
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   *@return the key of the deployed process this instance belongs to. 
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   *@return the key of the process instance 
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * Copy the current immutable object by replacing the {@link ProcessInstanceResultRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceResultRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableProcessInstanceResultRecordValue(newValue, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceResultRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceResultRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcessInstanceResultRecordValue(this.variables, value, this.version, this.processDefinitionKey, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceResultRecordValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceResultRecordValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableProcessInstanceResultRecordValue(this.variables, this.bpmnProcessId, value, this.processDefinitionKey, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceResultRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceResultRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcessInstanceResultRecordValue(this.variables, this.bpmnProcessId, this.version, value, this.processInstanceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceResultRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceResultRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessInstanceResultRecordValue(this.variables, this.bpmnProcessId, this.version, this.processDefinitionKey, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceResultRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceResultRecordValue
        && equalTo(0, (ImmutableProcessInstanceResultRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceResultRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && version == another.version
        && processDefinitionKey == another.processDefinitionKey
        && processInstanceKey == another.processInstanceKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code bpmnProcessId}, {@code version}, {@code processDefinitionKey}, {@code processInstanceKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceResultRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceResultRecordValue{"
        + "variables=" + variables
        + ", bpmnProcessId=" + bpmnProcessId
        + ", version=" + version
        + ", processDefinitionKey=" + processDefinitionKey
        + ", processInstanceKey=" + processInstanceKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceResultRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceResultRecordValue instance
   */
  public static ImmutableProcessInstanceResultRecordValue copyOf(ProcessInstanceResultRecordValue instance) {
    if (instance instanceof ImmutableProcessInstanceResultRecordValue) {
      return (ImmutableProcessInstanceResultRecordValue) instance;
    }
    return ImmutableProcessInstanceResultRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceResultRecordValue ImmutableProcessInstanceResultRecordValue}.
   * <pre>
   * ImmutableProcessInstanceResultRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link ProcessInstanceResultRecordValue#getVariables() variables} mappings
   *    .withBpmnProcessId(String | null) // nullable {@link ProcessInstanceResultRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withVersion(int) // optional {@link ProcessInstanceResultRecordValue#getVersion() version}
   *    .withProcessDefinitionKey(long) // optional {@link ProcessInstanceResultRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withProcessInstanceKey(long) // optional {@link ProcessInstanceResultRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceResultRecordValue builder
   */
  public static ImmutableProcessInstanceResultRecordValue.Builder builder() {
    return new ImmutableProcessInstanceResultRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceResultRecordValue ImmutableProcessInstanceResultRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceResultRecordValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private @Nullable String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private long processInstanceKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceResultRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessInstanceResultRecordValue) {
        ProcessInstanceResultRecordValue instance = (ProcessInstanceResultRecordValue) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        withVersion(instance.getVersion());
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link ProcessInstanceResultRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(@Nullable String key, @Nullable Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProcessInstanceResultRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProcessInstanceResultRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProcessInstanceResultRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceResultRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceResultRecordValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceResultRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceResultRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.bpmnProcessId = null;
      this.version = 0;
      this.processDefinitionKey = 0;
      this.processInstanceKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceResultRecordValue ImmutableProcessInstanceResultRecordValue}.
     * @return An immutable instance of ProcessInstanceResultRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceResultRecordValue build() {
      return new ImmutableProcessInstanceResultRecordValue(
          createUnmodifiableMap(false, false, variables),
          bpmnProcessId,
          version,
          processDefinitionKey,
          processInstanceKey);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
