package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Process}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcess.builder()}.
 */
@Generated(from = "Process", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProcess implements Process {
  private final String bpmnProcessId;
  private final int version;
  private final long processDefinitionKey;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private final byte[] resource;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcess(
      String bpmnProcessId,
      int version,
      long processDefinitionKey,
      String resourceName,
      byte[] checksum,
      boolean duplicate,
      byte[] resource) {
    this.bpmnProcessId = bpmnProcessId;
    this.version = version;
    this.processDefinitionKey = processDefinitionKey;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
    this.resource = resource;
  }

  /**
   *@return the bpmn process ID of this process 
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   *@return the version of this process 
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   *@return the key of this process 
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   *@return the name of the resource through which this process was deployed 
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   *@return the checksum of the process (MD5) 
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * return true if the process is a duplicate (and has been deployed previously), false otherwise
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   *@return returns the corresponding binary resource 
   */
  @Override
  public byte[] getResource() {
    return resource;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Process#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcess withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcess(
        value,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Process#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcess withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableProcess(
        this.bpmnProcessId,
        value,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Process#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcess withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcess(
        this.bpmnProcessId,
        this.version,
        value,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Process#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcess withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableProcess(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        value,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Process#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcess withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableProcess(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        newValue,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Process#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcess withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableProcess(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        value,
        this.resource);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Process#getResource() resource}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for resource
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcess withResource(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableProcess(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcess} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcess
        && equalTo(0, (ImmutableProcess) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcess another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && version == another.version
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate
        && Arrays.equals(resource, another.resource);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code bpmnProcessId}, {@code version}, {@code processDefinitionKey}, {@code resourceName}, {@code checksum}, {@code duplicate}, {@code resource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    h += (h << 5) + Arrays.hashCode(resource);
    return h;
  }

  /**
   * Prints the immutable value {@code Process} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Process{"
        + "bpmnProcessId=" + bpmnProcessId
        + ", version=" + version
        + ", processDefinitionKey=" + processDefinitionKey
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + ", resource=" + Arrays.toString(resource)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Process} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Process instance
   */
  public static ImmutableProcess copyOf(Process instance) {
    if (instance instanceof ImmutableProcess) {
      return (ImmutableProcess) instance;
    }
    return ImmutableProcess.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcess ImmutableProcess}.
   * <pre>
   * ImmutableProcess.builder()
   *    .withBpmnProcessId(String | null) // nullable {@link Process#getBpmnProcessId() bpmnProcessId}
   *    .withVersion(int) // optional {@link Process#getVersion() version}
   *    .withProcessDefinitionKey(long) // optional {@link Process#getProcessDefinitionKey() processDefinitionKey}
   *    .withResourceName(String | null) // nullable {@link Process#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link Process#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link Process#isDuplicate() duplicate}
   *    .withResource(byte[] | null) // nullable {@link Process#getResource() resource}
   *    .build();
   * </pre>
   * @return A new ImmutableProcess builder
   */
  public static ImmutableProcess.Builder builder() {
    return new ImmutableProcess.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcess ImmutableProcess}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Process", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private @Nullable String resourceName;
    private @Nullable byte[] checksum;
    private boolean duplicate;
    private @Nullable byte[] resource;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.Process} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Process instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Process) {
        Process instance = (Process) object;
        byte[] resourceValue = instance.getResource();
        if (resourceValue != null) {
          withResource(resourceValue);
        }
        if ((bits & 0x1L) == 0) {
          byte[] checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            withChecksum(checksumValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String resourceNameValue = instance.getResourceName();
          if (resourceNameValue != null) {
            withResourceName(resourceNameValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String bpmnProcessIdValue = instance.getBpmnProcessId();
          if (bpmnProcessIdValue != null) {
            withBpmnProcessId(bpmnProcessIdValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          withDuplicate(instance.isDuplicate());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          withVersion(instance.getVersion());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          withProcessDefinitionKey(instance.getProcessDefinitionKey());
          bits |= 0x20L;
        }
      }
      if (object instanceof ProcessMetadataValue) {
        ProcessMetadataValue instance = (ProcessMetadataValue) object;
        if ((bits & 0x1L) == 0) {
          byte[] checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            withChecksum(checksumValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String resourceNameValue = instance.getResourceName();
          if (resourceNameValue != null) {
            withResourceName(resourceNameValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String bpmnProcessIdValue = instance.getBpmnProcessId();
          if (bpmnProcessIdValue != null) {
            withBpmnProcessId(bpmnProcessIdValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          withDuplicate(instance.isDuplicate());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          withVersion(instance.getVersion());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          withProcessDefinitionKey(instance.getProcessDefinitionKey());
          bits |= 0x20L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Process#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link Process#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link Process#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link Process#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link Process#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link Process#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Initializes the value for the {@link Process#getResource() resource} attribute.
     * @param resource The elements for resource
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResource(byte... resource) {
      this.resource = resource;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.bpmnProcessId = null;
      this.version = 0;
      this.processDefinitionKey = 0;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      this.resource = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcess ImmutableProcess}.
     * @return An immutable instance of Process
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcess build() {
      return new ImmutableProcess(bpmnProcessId, version, processDefinitionKey, resourceName, checksum, duplicate, resource);
    }



  }



}
