/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;


/**
 * Broker topology information
 */
@SuppressWarnings("all")
public final class BrokerInfoEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 201;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "8.2.6";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final BrokerInfoEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public BrokerInfoEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public BrokerInfoEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int nodeIdId()
    {
        return 1;
    }

    public static int nodeIdSinceVersion()
    {
        return 0;
    }

    public static int nodeIdEncodingOffset()
    {
        return 0;
    }

    public static int nodeIdEncodingLength()
    {
        return 4;
    }

    public static String nodeIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int nodeIdNullValue()
    {
        return -2147483648;
    }

    public static int nodeIdMinValue()
    {
        return -2147483647;
    }

    public static int nodeIdMaxValue()
    {
        return 2147483647;
    }

    public BrokerInfoEncoder nodeId(final int value)
    {
        buffer.putInt(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int partitionsCountId()
    {
        return 2;
    }

    public static int partitionsCountSinceVersion()
    {
        return 0;
    }

    public static int partitionsCountEncodingOffset()
    {
        return 4;
    }

    public static int partitionsCountEncodingLength()
    {
        return 4;
    }

    public static String partitionsCountMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int partitionsCountNullValue()
    {
        return -2147483648;
    }

    public static int partitionsCountMinValue()
    {
        return -2147483647;
    }

    public static int partitionsCountMaxValue()
    {
        return 2147483647;
    }

    public BrokerInfoEncoder partitionsCount(final int value)
    {
        buffer.putInt(offset + 4, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int clusterSizeId()
    {
        return 3;
    }

    public static int clusterSizeSinceVersion()
    {
        return 0;
    }

    public static int clusterSizeEncodingOffset()
    {
        return 8;
    }

    public static int clusterSizeEncodingLength()
    {
        return 4;
    }

    public static String clusterSizeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int clusterSizeNullValue()
    {
        return -2147483648;
    }

    public static int clusterSizeMinValue()
    {
        return -2147483647;
    }

    public static int clusterSizeMaxValue()
    {
        return 2147483647;
    }

    public BrokerInfoEncoder clusterSize(final int value)
    {
        buffer.putInt(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int replicationFactorId()
    {
        return 4;
    }

    public static int replicationFactorSinceVersion()
    {
        return 0;
    }

    public static int replicationFactorEncodingOffset()
    {
        return 12;
    }

    public static int replicationFactorEncodingLength()
    {
        return 4;
    }

    public static String replicationFactorMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int replicationFactorNullValue()
    {
        return -2147483648;
    }

    public static int replicationFactorMinValue()
    {
        return -2147483647;
    }

    public static int replicationFactorMaxValue()
    {
        return 2147483647;
    }

    public BrokerInfoEncoder replicationFactor(final int value)
    {
        buffer.putInt(offset + 12, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    private final AddressesEncoder addresses = new AddressesEncoder(this);

    public static long addressesId()
    {
        return 5;
    }

    public AddressesEncoder addressesCount(final int count)
    {
        addresses.wrap(buffer, count);
        return addresses;
    }

    public static final class AddressesEncoder
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        AddressesEncoder(final BrokerInfoEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)0, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public AddressesEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putByte(initialLimit + 2, (byte)count);

            return count;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 0;
        }

        public static int apiNameId()
        {
            return 6;
        }

        public static String apiNameCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String apiNameMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int apiNameHeaderLength()
        {
            return 4;
        }

        public AddressesEncoder putApiName(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public AddressesEncoder putApiName(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public AddressesEncoder apiName(final String value)
        {
            final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

            final int length = bytes.length;
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, bytes, 0, length);

            return this;
        }

        public static int addressId()
        {
            return 7;
        }

        public static String addressCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String addressMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int addressHeaderLength()
        {
            return 4;
        }

        public AddressesEncoder putAddress(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public AddressesEncoder putAddress(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public AddressesEncoder address(final String value)
        {
            final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

            final int length = bytes.length;
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, bytes, 0, length);

            return this;
        }
    }

    private final PartitionRolesEncoder partitionRoles = new PartitionRolesEncoder(this);

    public static long partitionRolesId()
    {
        return 8;
    }

    public PartitionRolesEncoder partitionRolesCount(final int count)
    {
        partitionRoles.wrap(buffer, count);
        return partitionRoles;
    }

    public static final class PartitionRolesEncoder
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PartitionRolesEncoder(final BrokerInfoEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)5, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PartitionRolesEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putByte(initialLimit + 2, (byte)count);

            return count;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 5;
        }

        public static int partitionIdId()
        {
            return 9;
        }

        public static int partitionIdSinceVersion()
        {
            return 0;
        }

        public static int partitionIdEncodingOffset()
        {
            return 0;
        }

        public static int partitionIdEncodingLength()
        {
            return 4;
        }

        public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int partitionIdNullValue()
        {
            return -2147483648;
        }

        public static int partitionIdMinValue()
        {
            return -2147483647;
        }

        public static int partitionIdMaxValue()
        {
            return 2147483647;
        }

        public PartitionRolesEncoder partitionId(final int value)
        {
            buffer.putInt(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int roleId()
        {
            return 10;
        }

        public static int roleSinceVersion()
        {
            return 0;
        }

        public static int roleEncodingOffset()
        {
            return 4;
        }

        public static int roleEncodingLength()
        {
            return 1;
        }

        public static String roleMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public PartitionRolesEncoder role(final PartitionRole value)
        {
            buffer.putByte(offset + 4, (byte)value.value());
            return this;
        }
    }

    private final PartitionLeaderTermsEncoder partitionLeaderTerms = new PartitionLeaderTermsEncoder(this);

    public static long partitionLeaderTermsId()
    {
        return 11;
    }

    public PartitionLeaderTermsEncoder partitionLeaderTermsCount(final int count)
    {
        partitionLeaderTerms.wrap(buffer, count);
        return partitionLeaderTerms;
    }

    public static final class PartitionLeaderTermsEncoder
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PartitionLeaderTermsEncoder(final BrokerInfoEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)12, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PartitionLeaderTermsEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putByte(initialLimit + 2, (byte)count);

            return count;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 12;
        }

        public static int partitionIdId()
        {
            return 12;
        }

        public static int partitionIdSinceVersion()
        {
            return 0;
        }

        public static int partitionIdEncodingOffset()
        {
            return 0;
        }

        public static int partitionIdEncodingLength()
        {
            return 4;
        }

        public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int partitionIdNullValue()
        {
            return -2147483648;
        }

        public static int partitionIdMinValue()
        {
            return -2147483647;
        }

        public static int partitionIdMaxValue()
        {
            return 2147483647;
        }

        public PartitionLeaderTermsEncoder partitionId(final int value)
        {
            buffer.putInt(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int termId()
        {
            return 13;
        }

        public static int termSinceVersion()
        {
            return 0;
        }

        public static int termEncodingOffset()
        {
            return 4;
        }

        public static int termEncodingLength()
        {
            return 8;
        }

        public static String termMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long termNullValue()
        {
            return -9223372036854775808L;
        }

        public static long termMinValue()
        {
            return -9223372036854775807L;
        }

        public static long termMaxValue()
        {
            return 9223372036854775807L;
        }

        public PartitionLeaderTermsEncoder term(final long value)
        {
            buffer.putLong(offset + 4, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }

    }

    private final PartitionHealthEncoder partitionHealth = new PartitionHealthEncoder(this);

    public static long partitionHealthId()
    {
        return 15;
    }

    public PartitionHealthEncoder partitionHealthCount(final int count)
    {
        partitionHealth.wrap(buffer, count);
        return partitionHealth;
    }

    public static final class PartitionHealthEncoder
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PartitionHealthEncoder(final BrokerInfoEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)5, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PartitionHealthEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putByte(initialLimit + 2, (byte)count);

            return count;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 5;
        }

        public static int partitionIdId()
        {
            return 16;
        }

        public static int partitionIdSinceVersion()
        {
            return 0;
        }

        public static int partitionIdEncodingOffset()
        {
            return 0;
        }

        public static int partitionIdEncodingLength()
        {
            return 4;
        }

        public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int partitionIdNullValue()
        {
            return -2147483648;
        }

        public static int partitionIdMinValue()
        {
            return -2147483647;
        }

        public static int partitionIdMaxValue()
        {
            return 2147483647;
        }

        public PartitionHealthEncoder partitionId(final int value)
        {
            buffer.putInt(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int healthStatusId()
        {
            return 17;
        }

        public static int healthStatusSinceVersion()
        {
            return 0;
        }

        public static int healthStatusEncodingOffset()
        {
            return 4;
        }

        public static int healthStatusEncodingLength()
        {
            return 1;
        }

        public static String healthStatusMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public PartitionHealthEncoder healthStatus(final PartitionHealthStatus value)
        {
            buffer.putByte(offset + 4, (byte)value.value());
            return this;
        }
    }

    public static int versionId()
    {
        return 14;
    }

    public static String versionCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.UTF_8.name();
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionHeaderLength()
    {
        return 4;
    }

    public BrokerInfoEncoder putVersion(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public BrokerInfoEncoder putVersion(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public BrokerInfoEncoder version(final String value)
    {
        final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

        final int length = bytes.length;
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final BrokerInfoDecoder decoder = new BrokerInfoDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
