package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessEventRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessEventRecordValue.builder()}.
 */
@Generated(from = "ProcessEventRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableProcessEventRecordValue.Builder.class)
public final class ImmutableProcessEventRecordValue
    implements ProcessEventRecordValue {
  private final Map<String, Object> variables;
  private final long processInstanceKey;
  private final long scopeKey;
  private final String targetElementId;
  private final long processDefinitionKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessEventRecordValue(
      Map<String, Object> variables,
      long processInstanceKey,
      long scopeKey,
      String targetElementId,
      long processDefinitionKey) {
    this.variables = variables;
    this.processInstanceKey = processInstanceKey;
    this.scopeKey = scopeKey;
    this.targetElementId = targetElementId;
    this.processDefinitionKey = processDefinitionKey;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the key identifying the event's scope
   */
  @Override
  public long getScopeKey() {
    return scopeKey;
  }

  /**
   * @return the ID of the element which should react to the event
   */
  @Override
  public String getTargetElementId() {
    return targetElementId;
  }

  /**
   * @return the key of the deployed process this instance belongs to.
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * Copy the current immutable object by replacing the {@link ProcessEventRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessEventRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableProcessEventRecordValue(
        newValue,
        this.processInstanceKey,
        this.scopeKey,
        this.targetElementId,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessEventRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessEventRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessEventRecordValue(this.variables, value, this.scopeKey, this.targetElementId, this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessEventRecordValue#getScopeKey() scopeKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scopeKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessEventRecordValue withScopeKey(long value) {
    if (this.scopeKey == value) return this;
    return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, value, this.targetElementId, this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessEventRecordValue#getTargetElementId() targetElementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetElementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessEventRecordValue withTargetElementId(String value) {
    if (Objects.equals(this.targetElementId, value)) return this;
    return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.scopeKey, value, this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessEventRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessEventRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.scopeKey, this.targetElementId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessEventRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessEventRecordValue
        && equalTo(0, (ImmutableProcessEventRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessEventRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && processInstanceKey == another.processInstanceKey
        && scopeKey == another.scopeKey
        && Objects.equals(targetElementId, another.targetElementId)
        && processDefinitionKey == another.processDefinitionKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code processInstanceKey}, {@code scopeKey}, {@code targetElementId}, {@code processDefinitionKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(scopeKey);
    h += (h << 5) + Objects.hashCode(targetElementId);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessEventRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessEventRecordValue{"
        + "variables=" + variables
        + ", processInstanceKey=" + processInstanceKey
        + ", scopeKey=" + scopeKey
        + ", targetElementId=" + targetElementId
        + ", processDefinitionKey=" + processDefinitionKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessEventRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessEventRecordValue instance
   */
  public static ImmutableProcessEventRecordValue copyOf(ProcessEventRecordValue instance) {
    if (instance instanceof ImmutableProcessEventRecordValue) {
      return (ImmutableProcessEventRecordValue) instance;
    }
    return ImmutableProcessEventRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessEventRecordValue ImmutableProcessEventRecordValue}.
   * <pre>
   * ImmutableProcessEventRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link ProcessEventRecordValue#getVariables() variables} mappings
   *    .withProcessInstanceKey(long) // optional {@link ProcessEventRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withScopeKey(long) // optional {@link ProcessEventRecordValue#getScopeKey() scopeKey}
   *    .withTargetElementId(String | null) // nullable {@link ProcessEventRecordValue#getTargetElementId() targetElementId}
   *    .withProcessDefinitionKey(long) // optional {@link ProcessEventRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessEventRecordValue builder
   */
  public static ImmutableProcessEventRecordValue.Builder builder() {
    return new ImmutableProcessEventRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessEventRecordValue ImmutableProcessEventRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessEventRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private long scopeKey;
    private @Nullable String targetElementId;
    private long processDefinitionKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessEventRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessEventRecordValue) {
        ProcessEventRecordValue instance = (ProcessEventRecordValue) object;
        withScopeKey(instance.getScopeKey());
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        String targetElementIdValue = instance.getTargetElementId();
        if (targetElementIdValue != null) {
          withTargetElementId(targetElementIdValue);
        }
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link ProcessEventRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(@Nullable String key, @Nullable Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProcessEventRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProcessEventRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProcessEventRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessEventRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessEventRecordValue#getScopeKey() scopeKey} attribute.
     * @param scopeKey The value for scopeKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withScopeKey(long scopeKey) {
      this.scopeKey = scopeKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessEventRecordValue#getTargetElementId() targetElementId} attribute.
     * @param targetElementId The value for targetElementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTargetElementId(String targetElementId) {
      this.targetElementId = targetElementId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessEventRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.processInstanceKey = 0;
      this.scopeKey = 0;
      this.targetElementId = null;
      this.processDefinitionKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessEventRecordValue ImmutableProcessEventRecordValue}.
     * @return An immutable instance of ProcessEventRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessEventRecordValue build() {
      return new ImmutableProcessEventRecordValue(
          createUnmodifiableMap(false, false, variables),
          processInstanceKey,
          scopeKey,
          targetElementId,
          processDefinitionKey);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
