package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceBatchRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceBatchRecordValue.builder()}.
 */
@Generated(from = "ProcessInstanceBatchRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceBatchRecordValue.Builder.class)
public final class ImmutableProcessInstanceBatchRecordValue
    implements ProcessInstanceBatchRecordValue {
  private final long processInstanceKey;
  private final long batchElementInstanceKey;
  private final long index;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceBatchRecordValue(long processInstanceKey, long batchElementInstanceKey, long index) {
    this.processInstanceKey = processInstanceKey;
    this.batchElementInstanceKey = batchElementInstanceKey;
    this.index = index;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the element instance for which a batch action is being performed. This should be a
   *     container element (e.g. a subprocess).
   */
  @Override
  public long getBatchElementInstanceKey() {
    return batchElementInstanceKey;
  }

  /**
   * @return an index used to keep track of where we are in our batch process and where to start the
   *     next batch.
   */
  @Override
  public long getIndex() {
    return index;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceBatchRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceBatchRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessInstanceBatchRecordValue(value, this.batchElementInstanceKey, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceBatchRecordValue#getBatchElementInstanceKey() batchElementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for batchElementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceBatchRecordValue withBatchElementInstanceKey(long value) {
    if (this.batchElementInstanceKey == value) return this;
    return new ImmutableProcessInstanceBatchRecordValue(this.processInstanceKey, value, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceBatchRecordValue#getIndex() index} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceBatchRecordValue withIndex(long value) {
    if (this.index == value) return this;
    return new ImmutableProcessInstanceBatchRecordValue(this.processInstanceKey, this.batchElementInstanceKey, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceBatchRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceBatchRecordValue
        && equalTo(0, (ImmutableProcessInstanceBatchRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceBatchRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return processInstanceKey == another.processInstanceKey
        && batchElementInstanceKey == another.batchElementInstanceKey
        && index == another.index;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code processInstanceKey}, {@code batchElementInstanceKey}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(batchElementInstanceKey);
    h += (h << 5) + Long.hashCode(index);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceBatchRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceBatchRecordValue{"
        + "processInstanceKey=" + processInstanceKey
        + ", batchElementInstanceKey=" + batchElementInstanceKey
        + ", index=" + index
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceBatchRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceBatchRecordValue instance
   */
  public static ImmutableProcessInstanceBatchRecordValue copyOf(ProcessInstanceBatchRecordValue instance) {
    if (instance instanceof ImmutableProcessInstanceBatchRecordValue) {
      return (ImmutableProcessInstanceBatchRecordValue) instance;
    }
    return ImmutableProcessInstanceBatchRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceBatchRecordValue ImmutableProcessInstanceBatchRecordValue}.
   * <pre>
   * ImmutableProcessInstanceBatchRecordValue.builder()
   *    .withProcessInstanceKey(long) // optional {@link ProcessInstanceBatchRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withBatchElementInstanceKey(long) // optional {@link ProcessInstanceBatchRecordValue#getBatchElementInstanceKey() batchElementInstanceKey}
   *    .withIndex(long) // optional {@link ProcessInstanceBatchRecordValue#getIndex() index}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceBatchRecordValue builder
   */
  public static ImmutableProcessInstanceBatchRecordValue.Builder builder() {
    return new ImmutableProcessInstanceBatchRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceBatchRecordValue ImmutableProcessInstanceBatchRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceBatchRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private long processInstanceKey;
    private long batchElementInstanceKey;
    private long index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceBatchRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceBatchRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessInstanceBatchRecordValue) {
        ProcessInstanceBatchRecordValue instance = (ProcessInstanceBatchRecordValue) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        withIndex(instance.getIndex());
        withBatchElementInstanceKey(instance.getBatchElementInstanceKey());
      }
    }

    /**
     * Initializes the value for the {@link ProcessInstanceBatchRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceBatchRecordValue#getBatchElementInstanceKey() batchElementInstanceKey} attribute.
     * @param batchElementInstanceKey The value for batchElementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBatchElementInstanceKey(long batchElementInstanceKey) {
      this.batchElementInstanceKey = batchElementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceBatchRecordValue#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withIndex(long index) {
      this.index = index;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.processInstanceKey = 0;
      this.batchElementInstanceKey = 0;
      this.index = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceBatchRecordValue ImmutableProcessInstanceBatchRecordValue}.
     * @return An immutable instance of ProcessInstanceBatchRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceBatchRecordValue build() {
      return new ImmutableProcessInstanceBatchRecordValue(processInstanceKey, batchElementInstanceKey, index);
    }



  }



}
