/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.testcontainers.containers.ToxiproxyContainer;

public final class ProxyRegistry {
    private static final AtomicInteger PORT_GENERATOR = new AtomicInteger(1024);
    private final ConcurrentMap<String, ContainerProxy> proxies = new ConcurrentHashMap<String, ContainerProxy>();
    private final ToxiproxyContainer toxiproxy;
    private ToxiproxyClient lazyClient;

    public ProxyRegistry(ToxiproxyContainer toxiproxy) {
        this.toxiproxy = toxiproxy;
    }

    public ContainerProxy getOrCreateProxy(String upstream) {
        return this.proxies.computeIfAbsent(upstream, this::createProxy);
    }

    private ContainerProxy createProxy(String upstream) {
        int proxyPort = PORT_GENERATOR.getAndIncrement();
        try {
            Proxy proxy = this.getClient().createProxy(upstream, "0.0.0.0:%d".formatted(proxyPort), upstream);
            return new ContainerProxy(proxy, proxyPort);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private synchronized ToxiproxyClient getClient() {
        if (this.lazyClient == null) {
            this.lazyClient = new ToxiproxyClient(this.toxiproxy.getHost(), this.toxiproxy.getControlPort());
        }
        return this.lazyClient;
    }

    public record ContainerProxy(Proxy proxy, int internalPort) {
    }
}

