/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import feign.Feign;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.zeebe.containers.ZeebeNode;
import org.slf4j.event.Level;

public interface LoggersActuator {
    public static LoggersActuator of(ZeebeNode<?> node) {
        String endpoint = String.format("http://%s/actuator/loggers", node.getExternalMonitoringAddress());
        return LoggersActuator.of(endpoint);
    }

    public static LoggersActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(LoggersActuator.class, endpoint);
        return (LoggersActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    default public void set(String id, Level level) {
        this.set(id, new LoggerInfo(level.toString(), null));
    }

    @RequestLine(value="POST /{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void set(@Param String var1, LoggerInfo var2);

    @RequestLine(value="POST /{id}")
    @Headers(value={"Accept: application/json"})
    public LoggerInfo get(@Param String var1);

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public record LoggerInfo(String configuredLevel, String effectiveLevel) {
    }
}

