/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import java.util.List;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public final class GcsContainer
extends GenericContainer<GcsContainer> {
    private static final DockerImageName IMAGE = DockerImageName.parse((String)"fsouza/fake-gcs-server");
    private static final String IMAGE_TAG = "1";
    private static final int PORT = 8000;
    private final String domain;

    public GcsContainer(Network network, String domain) {
        super(IMAGE.withTag(IMAGE_TAG));
        this.domain = domain;
        this.setCommand(new String[]{"-scheme", "http", "-external-url", this.internalEndpoint(), "-port", String.valueOf(8000)});
        this.setExposedPorts(List.of(Integer.valueOf(8000)));
        this.setNetworkAliases(List.of(domain));
        this.setNetwork(network);
    }

    public String internalEndpoint() {
        return "http://" + this.domain + ":8000";
    }

    public String externalEndpoint() {
        return "http://%s:%d".formatted(this.getHost(), this.getMappedPort(8000));
    }
}

