/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.qa.util.cluster.TestStandaloneBroker;
import io.zeebe.containers.ZeebeBrokerNode;
import java.time.Instant;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;

public interface ActorClockActuator {
    public static ActorClockActuator of(ZeebeBrokerNode<?> node) {
        String endpoint = String.format("http://%s/actuator/clock", node.getExternalMonitoringAddress());
        return ActorClockActuator.of(endpoint);
    }

    public static ActorClockActuator of(TestStandaloneBroker node) {
        String endpoint = String.format("http://%s/actuator/clock", node.monitoringAddress());
        return ActorClockActuator.of(endpoint);
    }

    public static ActorClockActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(ActorClockActuator.class, endpoint);
        JacksonDecoder decoder = new JacksonDecoder(List.of(new Jdk8Module(), new JavaTimeModule()));
        return (ActorClockActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)decoder).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="GET")
    @Headers(value={"Accept: application/json"})
    public Response getCurrentClock();

    @RequestLine(value="POST /add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Response addTime(@RequestBody AddTimeRequest var1);

    public record AddTimeRequest(Long offsetMilli) {
    }

    public record Response(long epochMilli, Instant instant) {
    }
}

