/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.zeebe.containers.ZeebeNode;

public interface ExportingActuator {
    public static ExportingActuator of(ZeebeNode<?> node) {
        String endpoint = String.format("http://%s/actuator/exporting", node.getExternalMonitoringAddress());
        return ExportingActuator.of(endpoint);
    }

    public static ExportingActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(ExportingActuator.class, endpoint);
        return (ExportingActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="POST /pause")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void pause();

    @RequestLine(value="POST /pause?soft=true")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void softPause();

    @RequestLine(value="POST /resume")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void resume();
}

