/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.StandaloneBroker;
import io.camunda.zeebe.broker.shared.WorkingDirectoryConfiguration;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.qa.util.actuator.BrokerHealthActuator;
import io.camunda.zeebe.qa.util.actuator.GatewayHealthActuator;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestGateway;
import io.camunda.zeebe.qa.util.cluster.TestSpringApplication;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.util.unit.DataSize;

public final class TestStandaloneBroker
extends TestSpringApplication<TestStandaloneBroker>
implements TestGateway<TestStandaloneBroker> {
    private static final String RECORDING_EXPORTER_ID = "recordingExporter";
    private final BrokerCfg config = new BrokerCfg();

    public TestStandaloneBroker() {
        super(StandaloneBroker.class);
        this.config.getNetwork().getCommandApi().setPort(SocketUtil.getNextAddress().getPort());
        this.config.getNetwork().getInternalApi().setPort(SocketUtil.getNextAddress().getPort());
        this.config.getGateway().getNetwork().setPort(SocketUtil.getNextAddress().getPort());
        this.config.getData().setLogSegmentSize(DataSize.ofMegabytes((long)16L));
        this.config.getData().getDisk().getFreeSpace().setProcessing(DataSize.ofMegabytes((long)128L));
        this.config.getData().getDisk().getFreeSpace().setReplication(DataSize.ofMegabytes((long)64L));
        this.withBean("uninitializedBrokerCfg", this.config, BrokerCfg.class);
    }

    @Override
    public TestStandaloneBroker self() {
        return this;
    }

    @Override
    public MemberId nodeId() {
        return MemberId.from((String)String.valueOf(this.config.getCluster().getNodeId()));
    }

    @Override
    public String host() {
        return this.config.getNetwork().getHost();
    }

    @Override
    public HealthActuator healthActuator() {
        return this.brokerHealth();
    }

    @Override
    public boolean isGateway() {
        return this.config.getGateway().isEnable();
    }

    @Override
    public int mappedPort(TestZeebePort port) {
        return switch (port) {
            case TestZeebePort.COMMAND -> this.config.getNetwork().getCommandApi().getPort();
            case TestZeebePort.GATEWAY -> this.config.getGateway().getNetwork().getPort();
            case TestZeebePort.CLUSTER -> this.config.getNetwork().getInternalApi().getPort();
            default -> super.mappedPort(port);
        };
    }

    @Override
    protected SpringApplicationBuilder createSpringBuilder() {
        return super.createSpringBuilder().profiles(new String[]{Profile.BROKER.getId()});
    }

    @Override
    public String gatewayAddress() {
        if (!this.isGateway()) {
            throw new IllegalStateException("Expected to get the gateway address for this broker, but the embedded gateway is not enabled");
        }
        return TestGateway.super.gatewayAddress();
    }

    @Override
    public GatewayHealthActuator gatewayHealth() {
        throw new UnsupportedOperationException("Brokers do not support the gateway health indicators");
    }

    @Override
    public TestStandaloneBroker withGatewayConfig(Consumer<GatewayCfg> modifier) {
        modifier.accept((GatewayCfg)this.config.getGateway());
        return this;
    }

    @Override
    public GatewayCfg gatewayConfig() {
        return this.config.getGateway();
    }

    @Override
    public ZeebeClientBuilder newClientBuilder() {
        if (!this.isGateway()) {
            throw new IllegalStateException("Cannot create a new client for this broker, as it does not have an embedded gateway");
        }
        return TestGateway.super.newClientBuilder();
    }

    public BrokerCfg brokerConfig() {
        return this.config;
    }

    public TestStandaloneBroker withBrokerConfig(Consumer<BrokerCfg> modifier) {
        modifier.accept(this.config);
        return this;
    }

    public BrokerHealthActuator brokerHealth() {
        return BrokerHealthActuator.ofAddress(this.monitoringAddress());
    }

    public TestStandaloneBroker withRecordingExporter(boolean useRecordingExporter) {
        if (!useRecordingExporter) {
            this.config.getExporters().remove(RECORDING_EXPORTER_ID);
            return this;
        }
        return this.withExporter(RECORDING_EXPORTER_ID, cfg -> cfg.setClassName(RecordingExporter.class.getName()));
    }

    public TestStandaloneBroker withExporter(String id, Consumer<ExporterCfg> modifier) {
        ExporterCfg exporterConfig = this.config.getExporters().computeIfAbsent(id, ignored -> new ExporterCfg());
        modifier.accept(exporterConfig);
        return this;
    }

    public TestStandaloneBroker withWorkingDirectory(Path directory) {
        return (TestStandaloneBroker)this.withBean("workingDirectory", new WorkingDirectoryConfiguration.WorkingDirectory(directory, false), WorkingDirectoryConfiguration.WorkingDirectory.class);
    }
}

