/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster.util;

import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public final class ContextOverrideInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Map<String, Bean<?>> beans;
    private final Map<String, Object> properties;

    public ContextOverrideInitializer(Map<String, Bean<?>> beans, Map<String, Object> properties) {
        this.beans = beans;
        this.properties = properties;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        MutablePropertySources sources = environment.getPropertySources();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        this.beans.forEach((qualifier, bean) -> this.overrideBean(beanFactory, (String)qualifier, bean.value, bean.type));
        sources.addFirst((PropertySource)new MapPropertySource("test properties", this.properties));
    }

    private void overrideBean(ConfigurableListableBeanFactory beanFactory, String qualifier, Object object, Class<?> type) {
        if (object == null) {
            return;
        }
        beanFactory.registerResolvableDependency(type, object);
        beanFactory.registerSingleton(qualifier, object);
    }

    public record Bean<T>(T value, Class<T> type) {
    }
}

