/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.gateway.StandaloneGateway;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.qa.util.actuator.GatewayHealthActuator;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestGateway;
import io.camunda.zeebe.qa.util.cluster.TestSpringApplication;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import java.util.function.Consumer;
import org.springframework.boot.builder.SpringApplicationBuilder;

public final class TestStandaloneGateway
extends TestSpringApplication<TestStandaloneGateway>
implements TestGateway<TestStandaloneGateway> {
    private final GatewayCfg config = new GatewayCfg();

    public TestStandaloneGateway() {
        super(StandaloneGateway.class);
        this.config.getNetwork().setHost("0.0.0.0");
        this.config.getNetwork().setPort(SocketUtil.getNextAddress().getPort());
        this.config.getCluster().setPort(SocketUtil.getNextAddress().getPort());
        this.withBean("config", this.config, GatewayCfg.class);
    }

    @Override
    public TestStandaloneGateway self() {
        return this;
    }

    @Override
    public MemberId nodeId() {
        return MemberId.from((String)this.config.getCluster().getMemberId());
    }

    @Override
    public String host() {
        return this.config.getNetwork().getHost();
    }

    @Override
    public HealthActuator healthActuator() {
        return GatewayHealthActuator.ofAddress(this.monitoringAddress());
    }

    @Override
    public boolean isGateway() {
        return true;
    }

    @Override
    public int mappedPort(TestZeebePort port) {
        return switch (port) {
            case TestZeebePort.GATEWAY -> this.config.getNetwork().getPort();
            case TestZeebePort.CLUSTER -> this.config.getCluster().getPort();
            default -> super.mappedPort(port);
        };
    }

    @Override
    protected SpringApplicationBuilder createSpringBuilder() {
        return super.createSpringBuilder().profiles(new String[]{Profile.GATEWAY.getId()});
    }

    @Override
    public TestStandaloneGateway withGatewayConfig(Consumer<GatewayCfg> modifier) {
        modifier.accept(this.config);
        return this.self();
    }

    @Override
    public GatewayCfg gatewayConfig() {
        return this.config;
    }
}

