/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.ToxiproxyContainer;

public final class ProxyRegistry {
    private static final int MIN_EXPOSED_PORT = 10000;
    private static final int MAX_EXPOSED_PORT = 10032;
    private static final AtomicInteger PORT_GENERATOR = new AtomicInteger(10000);
    private final ConcurrentMap<String, ContainerProxy> proxies = new ConcurrentHashMap<String, ContainerProxy>();
    private final ToxiproxyContainer toxiproxy;
    private ToxiproxyClient lazyClient;

    public ProxyRegistry(ToxiproxyContainer toxiproxy) {
        this.toxiproxy = toxiproxy;
    }

    public static ToxiproxyContainer addExposedPorts(ToxiproxyContainer container) {
        container.addExposedPorts(IntStream.range(10000, 10032).toArray());
        container.withAccessToHost(true);
        return container;
    }

    public ContainerProxy getOrCreateProxy(String upstream) {
        return this.proxies.computeIfAbsent(upstream, this::createProxy);
    }

    public ContainerProxy getOrCreateHostProxy(int port) {
        String upstream = "host.testcontainers.internal:" + port;
        Testcontainers.exposeHostPorts((int[])new int[]{port});
        return this.getOrCreateProxy(upstream);
    }

    private ContainerProxy createProxy(String upstream) {
        int proxyPort = PORT_GENERATOR.getAndIncrement();
        if (proxyPort >= 10032) {
            throw new IllegalStateException("Cannot proxy more than %d ports with a single container".formatted(32));
        }
        try {
            Proxy proxy = this.getClient().createProxy(upstream, "0.0.0.0:%d".formatted(proxyPort), upstream);
            return new ContainerProxy(proxy, proxyPort);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private synchronized ToxiproxyClient getClient() {
        if (this.lazyClient == null) {
            this.lazyClient = new ToxiproxyClient(this.toxiproxy.getHost(), this.toxiproxy.getControlPort());
        }
        return this.lazyClient;
    }

    public record ContainerProxy(Proxy proxy, int internalPort) {
    }
}

