/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Body;
import feign.Feign;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.management.cluster.GetTopologyResponse;
import io.camunda.zeebe.management.cluster.PlannedOperationsResponse;
import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.zeebe.containers.ZeebeNode;
import java.util.List;

public interface ClusterActuator {
    public static ClusterActuator of(ZeebeNode<?> node) {
        return ClusterActuator.ofAddress(node.getExternalMonitoringAddress());
    }

    public static ClusterActuator of(TestApplication<?> node) {
        return ClusterActuator.ofAddress(node.monitoringAddress());
    }

    public static ClusterActuator ofAddress(String address) {
        String endpoint = String.format("http://%s/actuator/cluster", address);
        return ClusterActuator.of(endpoint);
    }

    public static ClusterActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(ClusterActuator.class, endpoint);
        return (ClusterActuator)Feign.builder().encoder((Encoder)new JacksonEncoder(List.of(new Jdk8Module(), new JavaTimeModule()))).decoder((Decoder)new JacksonDecoder(List.of(new Jdk8Module(), new JavaTimeModule()))).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="POST /brokers/{brokerId}/partitions/{partitionId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @Body(value="%7B\"priority\": \"{priority}\"%7D")
    public PlannedOperationsResponse joinPartition(@Param int var1, @Param int var2, @Param int var3);

    @RequestLine(value="DELETE /brokers/{brokerId}/partitions/{partitionId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse leavePartition(@Param int var1, @Param int var2);

    @RequestLine(value="GET")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GetTopologyResponse getTopology();

    @RequestLine(value="POST /brokers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse scaleBrokers(@RequestBody List<Integer> var1);

    @RequestLine(value="POST /brokers?dryRun={dryRun}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse scaleBrokers(@RequestBody List<Integer> var1, @Param boolean var2);

    @RequestLine(value="POST /brokers/{brokerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse addBroker(@Param int var1);

    @RequestLine(value="DELETE /brokers/{brokerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse removeBroker(@Param int var1);

    @RequestLine(value="DELETE /changes/{changeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GetTopologyResponse cancelChange(@Param long var1);

    @RequestLine(value="POST /brokers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse scaleBrokersInvalidType(@RequestBody List<String> var1);

    @RequestLine(value="POST /brokers/{brokerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PlannedOperationsResponse addBrokerInvalidType(@Param String var1);
}

