/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.zeebe.containers.ZeebeNode;
import java.util.List;

public interface GatewayHealthActuator
extends HealthActuator {
    public static GatewayHealthActuator of(ZeebeNode<?> node) {
        return GatewayHealthActuator.ofAddress(node.getExternalMonitoringAddress());
    }

    public static GatewayHealthActuator ofAddress(String address) {
        return GatewayHealthActuator.of("http://" + address);
    }

    public static GatewayHealthActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(GatewayHealthActuator.class, endpoint);
        JacksonDecoder decoder = new JacksonDecoder(List.of(new Jdk8Module(), new JavaTimeModule()));
        return (GatewayHealthActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)decoder).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @Override
    @RequestLine(value="GET /actuator/health")
    public void ready();

    @Override
    @RequestLine(value="GET /actuator/health/startup")
    public void startup();

    @Override
    @RequestLine(value="GET /actuator/health/liveness")
    public void live();
}

