/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestHealthProbe;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;

public interface TestApplication<T extends TestApplication<T>>
extends AutoCloseable {
    public T start();

    public T stop();

    public boolean isStarted();

    @Override
    default public void close() {
        this.stop();
    }

    public T self();

    public <V> T withBean(String var1, V var2, Class<V> var3);

    public MemberId nodeId();

    default public String host() {
        return "localhost";
    }

    default public int mappedPort(TestZeebePort port) {
        return port.port();
    }

    default public String address(int port) {
        return this.host() + ":" + port;
    }

    default public String address(TestZeebePort port) {
        return this.address(this.mappedPort(port));
    }

    default public String monitoringAddress() {
        return this.address(TestZeebePort.MONITORING);
    }

    public HealthActuator healthActuator();

    default public void probe(TestHealthProbe probe) {
        switch (probe) {
            case LIVE: {
                this.healthActuator().live();
                break;
            }
            case READY: {
                this.healthActuator().ready();
                break;
            }
            case STARTED: {
                this.healthActuator().startup();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)probe));
            }
        }
    }

    public boolean isGateway();

    default public T await(TestHealthProbe probe, Duration timeout) {
        Awaitility.await((String)"until broker '%s' is '%s'".formatted(new Object[]{this.nodeId(), probe})).atMost(timeout).untilAsserted(() -> Assertions.assertThatCode(() -> this.probe(probe)).doesNotThrowAnyException());
        return this.self();
    }

    default public T await(TestHealthProbe probe) {
        return this.await(probe, Duration.ofSeconds(30L));
    }

    public <V> V bean(Class<V> var1);

    public T withProperty(String var1, Object var2);
}

