/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.camunda.zeebe.qa.util.cluster.TestCluster;
import io.camunda.zeebe.qa.util.cluster.TestGateway;
import io.camunda.zeebe.qa.util.cluster.TestStandaloneBroker;
import io.camunda.zeebe.qa.util.cluster.TestStandaloneGateway;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class TestClusterBuilder {
    private static final String DEFAULT_CLUSTER_NAME = "zeebe-cluster";
    private String name = "zeebe-cluster";
    private int gatewaysCount = 0;
    private int brokersCount = 1;
    private int partitionsCount = 1;
    private int replicationFactor = 1;
    private boolean useEmbeddedGateway = true;
    private boolean useRecordingExporter = true;
    private Consumer<TestApplication<?>> nodeConfig = node -> {};
    private BiConsumer<MemberId, TestStandaloneBroker> brokerConfig = (id, broker) -> {};
    private BiConsumer<MemberId, TestGateway<?>> gatewayConfig = (id, gateway) -> {};
    private final Map<MemberId, TestStandaloneGateway> gateways = new HashMap<MemberId, TestStandaloneGateway>();
    private final Map<MemberId, TestStandaloneBroker> brokers = new HashMap<MemberId, TestStandaloneBroker>();

    public TestClusterBuilder withEmbeddedGateway(boolean useEmbeddedGateway) {
        this.useEmbeddedGateway = useEmbeddedGateway;
        return this;
    }

    public TestClusterBuilder withGatewaysCount(int gatewaysCount) {
        this.gatewaysCount = gatewaysCount;
        return this;
    }

    public TestClusterBuilder withBrokersCount(int brokersCount) {
        if (brokersCount < 0) {
            throw new IllegalArgumentException("Expected brokersCount to be at least 0, but was " + brokersCount);
        }
        this.brokersCount = brokersCount;
        if (brokersCount > 0) {
            this.partitionsCount = Math.max(this.partitionsCount, 1);
            this.replicationFactor = Math.max(this.replicationFactor, 1);
        } else {
            this.partitionsCount = 0;
            this.replicationFactor = 0;
        }
        return this;
    }

    public TestClusterBuilder withPartitionsCount(int partitionsCount) {
        if (partitionsCount <= 0) {
            throw new IllegalArgumentException("Expected partitionsCount to be at least 1, but was " + partitionsCount);
        }
        this.partitionsCount = partitionsCount;
        return this;
    }

    public TestClusterBuilder withReplicationFactor(int replicationFactor) {
        if (replicationFactor <= 0) {
            throw new IllegalArgumentException("Expected replicationFactor to be at least 1, but was " + replicationFactor);
        }
        this.replicationFactor = replicationFactor;
        return this;
    }

    public TestClusterBuilder withName(String name) {
        if (name == null || name.trim().length() < 3) {
            throw new IllegalArgumentException("Expected cluster name to be at least 3 characters, but was " + name);
        }
        this.name = name;
        return this;
    }

    public TestClusterBuilder withNodeConfig(Consumer<TestApplication<?>> modifier) {
        this.nodeConfig = modifier;
        return this;
    }

    public TestClusterBuilder withGatewayConfig(BiConsumer<MemberId, TestGateway<?>> modifier) {
        this.gatewayConfig = modifier;
        return this;
    }

    public TestClusterBuilder withGatewayConfig(Consumer<TestGateway<?>> modifier) {
        this.gatewayConfig = (memberId, gateway) -> modifier.accept((TestGateway<?>)gateway);
        return this;
    }

    public TestClusterBuilder withBrokerConfig(BiConsumer<MemberId, TestStandaloneBroker> modifier) {
        this.brokerConfig = modifier;
        return this;
    }

    public TestClusterBuilder withBrokerConfig(Consumer<TestStandaloneBroker> modifier) {
        this.brokerConfig = (id, broker) -> modifier.accept((TestStandaloneBroker)broker);
        return this;
    }

    public TestClusterBuilder useRecordingExporter(boolean useRecordingExporter) {
        this.useRecordingExporter = useRecordingExporter;
        return this;
    }

    public TestCluster build() {
        this.gateways.clear();
        this.brokers.clear();
        this.validate();
        this.createBrokers();
        this.createGateways();
        return new TestCluster(this.name, this.replicationFactor, this.partitionsCount, new HashMap<MemberId, TestStandaloneBroker>(this.brokers), new HashMap<MemberId, TestStandaloneGateway>(this.gateways));
    }

    private void applyConfigFunctions(MemberId id, TestApplication<?> zeebe) {
        this.nodeConfig.accept(zeebe);
        if (zeebe instanceof TestGateway) {
            TestGateway gateway = (TestGateway)zeebe;
            this.gatewayConfig.accept(id, gateway);
        }
        if (zeebe instanceof TestStandaloneBroker) {
            TestStandaloneBroker broker = (TestStandaloneBroker)zeebe;
            this.brokerConfig.accept(id, broker);
        }
    }

    private void validate() {
        if (this.replicationFactor > this.brokersCount) {
            throw new IllegalStateException("Expected replicationFactor to be less than or equal to brokersCount, but was " + this.replicationFactor + " > " + this.brokersCount);
        }
        if (this.brokersCount > 0) {
            if (this.partitionsCount < 1) {
                throw new IllegalStateException("Expected to have at least one partition if there are any brokers, but partitionsCount was " + this.partitionsCount);
            }
            if (this.replicationFactor < 1) {
                throw new IllegalStateException("Expected to have replication factor at least 1 if there are any brokers, but replicationFactor was " + this.replicationFactor);
            }
        }
    }

    private void createBrokers() {
        for (int i = 0; i < this.brokersCount; ++i) {
            MemberId memberId = MemberId.from((String)String.valueOf(i));
            TestStandaloneBroker broker = this.createBroker(i);
            this.applyConfigFunctions(memberId, broker);
            this.brokers.put(memberId, broker);
        }
        List<String> contactPoints = this.getInitialContactPoints();
        this.brokers.values().stream().map(TestStandaloneBroker::brokerConfig).map(BrokerCfg::getCluster).forEach(cfg -> cfg.setInitialContactPoints(contactPoints));
    }

    private TestStandaloneBroker createBroker(int index) {
        return new TestStandaloneBroker().withBrokerConfig((BrokerCfg cfg) -> {
            ClusterCfg cluster = cfg.getCluster();
            cluster.setNodeId(index);
            cluster.setPartitionsCount(this.partitionsCount);
            cluster.setReplicationFactor(this.replicationFactor);
            cluster.setClusterSize(this.brokersCount);
            cluster.setClusterName(this.name);
        }).withBrokerConfig((BrokerCfg cfg) -> cfg.getGateway().setEnable(this.useEmbeddedGateway)).withRecordingExporter(this.useRecordingExporter);
    }

    private void createGateways() {
        for (int i = 0; i < this.gatewaysCount; ++i) {
            String id = "gateway-" + i;
            MemberId memberId = MemberId.from((String)id);
            TestStandaloneGateway gateway = this.createGateway(id);
            this.applyConfigFunctions(memberId, gateway);
            this.gateways.put(memberId, gateway);
        }
    }

    private TestStandaloneGateway createGateway(String id) {
        return new TestStandaloneGateway().withGatewayConfig(cfg -> {
            io.camunda.zeebe.gateway.impl.configuration.ClusterCfg cluster = cfg.getCluster();
            cluster.setMemberId(id);
            cluster.setClusterName(this.name);
            cluster.setInitialContactPoints(this.getInitialContactPoints());
        });
    }

    private List<String> getInitialContactPoints() {
        return this.brokers.values().stream().map(builder -> builder.address(TestZeebePort.CLUSTER)).toList();
    }
}

