/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import io.camunda.zeebe.qa.util.cluster.util.ContextOverrideInitializer;
import io.camunda.zeebe.qa.util.cluster.util.RelaxedCollectorRegistry;
import io.camunda.zeebe.shared.MainSupport;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.client.ReactorResourceFactory;

abstract class TestSpringApplication<T extends TestSpringApplication<T>>
implements TestApplication<T> {
    private final Class<?> springApplication;
    private final Map<String, ContextOverrideInitializer.Bean<?>> beans;
    private final Map<String, Object> propertyOverrides;
    private final ReactorResourceFactory reactorResourceFactory = new ReactorResourceFactory();
    private ConfigurableApplicationContext springContext;

    public TestSpringApplication(Class<?> springApplication) {
        this(springApplication, new HashMap(), new HashMap<String, Object>());
    }

    private TestSpringApplication(Class<?> springApplication, Map<String, ContextOverrideInitializer.Bean<?>> beans, Map<String, Object> propertyOverrides) {
        this.springApplication = springApplication;
        this.beans = beans;
        this.propertyOverrides = propertyOverrides;
        this.overridePropertyIfAbsent("server.port", SocketUtil.getNextAddress().getPort());
        this.overridePropertyIfAbsent("management.server.port", SocketUtil.getNextAddress().getPort());
        if (!beans.containsKey("collectorRegistry")) {
            beans.put("collectorRegistry", new ContextOverrideInitializer.Bean<CollectorRegistry>(new RelaxedCollectorRegistry(), CollectorRegistry.class));
        }
        this.reactorResourceFactory.setUseGlobalResources(false);
        this.reactorResourceFactory.setShutdownQuietPeriod(Duration.ZERO);
        beans.put("reactorResourceFactory", new ContextOverrideInitializer.Bean<ReactorResourceFactory>(this.reactorResourceFactory, ReactorResourceFactory.class));
    }

    @Override
    public T start() {
        if (!this.isStarted()) {
            this.reactorResourceFactory.afterPropertiesSet();
            this.springContext = this.createSpringBuilder().run(this.commandLineArgs());
        }
        return (T)((TestSpringApplication)this.self());
    }

    @Override
    public T stop() {
        if (this.springContext != null) {
            this.springContext.close();
            this.springContext = null;
        }
        return (T)((TestSpringApplication)this.self());
    }

    @Override
    public boolean isStarted() {
        return this.springContext != null && this.springContext.isActive();
    }

    @Override
    public <V> T withBean(String qualifier, V bean, Class<V> type) {
        this.beans.put(qualifier, new ContextOverrideInitializer.Bean<V>(bean, type));
        return (T)((TestSpringApplication)this.self());
    }

    @Override
    public int mappedPort(TestZeebePort port) {
        return switch (port) {
            case TestZeebePort.REST -> this.restPort();
            case TestZeebePort.MONITORING -> this.monitoringPort();
            default -> throw new IllegalArgumentException("No known port %s; must one of MONITORING".formatted(new Object[]{port}));
        };
    }

    @Override
    public <V> V bean(Class<V> type) {
        return (V)this.springContext.getBean(type);
    }

    @Override
    public T withProperty(String key, Object value) {
        this.propertyOverrides.put(key, value);
        return (T)((TestSpringApplication)this.self());
    }

    protected String[] commandLineArgs() {
        return new String[0];
    }

    protected SpringApplicationBuilder createSpringBuilder() {
        return MainSupport.createDefaultApplicationBuilder().bannerMode(Banner.Mode.OFF).lazyInitialization(true).registerShutdownHook(false).initializers(new ApplicationContextInitializer[]{new ContextOverrideInitializer(this.beans, this.propertyOverrides)}).profiles(new String[]{Profile.TEST.getId()}).sources(new Class[]{this.springApplication});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{nodeId = " + String.valueOf(this.nodeId()) + "}";
    }

    private void overridePropertyIfAbsent(String key, Object value) {
        if (!this.propertyOverrides.containsKey(key)) {
            this.propertyOverrides.put(key, value);
        }
    }

    private int monitoringPort() {
        return this.serverPort("management.server.port");
    }

    private int restPort() {
        return this.serverPort("server.port");
    }

    private int serverPort(String property) {
        Object portProperty = this.springContext != null ? this.springContext.getEnvironment().getProperty(property) : this.propertyOverrides.get(property);
        if (portProperty == null) {
            throw new IllegalStateException("No property '%s' defined anywhere, cannot infer monitoring port".formatted(property));
        }
        if (portProperty instanceof Integer) {
            Integer port = (Integer)portProperty;
            return port;
        }
        return Integer.parseInt(portProperty.toString());
    }
}

