/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.jobstream;

import io.camunda.zeebe.qa.util.actuator.JobStreamActuator;
import io.camunda.zeebe.qa.util.jobstream.AbstractJobStreamsAssert;
import io.camunda.zeebe.shared.management.JobStreamEndpoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.condition.AllOf;

public final class JobStreamActuatorAssert
extends AbstractObjectAssert<JobStreamActuatorAssert, JobStreamActuator> {
    public JobStreamActuatorAssert(JobStreamActuator jobStreamActuator) {
        super((Object)jobStreamActuator, JobStreamActuatorAssert.class);
    }

    public static JobStreamActuatorAssert assertThat(JobStreamActuator actual) {
        return new JobStreamActuatorAssert(actual);
    }

    public ClientJobStreamsAssert clientStreams() {
        this.isNotNull();
        return new ClientJobStreamsAssert(((JobStreamActuator)this.actual).listClient());
    }

    public RemoteJobStreamsAssert remoteStreams() {
        this.isNotNull();
        return new RemoteJobStreamsAssert(((JobStreamActuator)this.actual).listRemote());
    }

    public static final class ClientJobStreamsAssert
    extends AbstractJobStreamsAssert<ClientJobStreamsAssert, JobStreamEndpoint.ClientJobStream> {
        public ClientJobStreamsAssert(Collection<JobStreamEndpoint.ClientJobStream> actual) {
            super(actual, ClientJobStreamsAssert.class);
        }

        public ClientJobStreamsAssert haveConnectedTo(int expectedCount, String jobType, int ... nodeId) {
            return (ClientJobStreamsAssert)this.haveExactly(expectedCount, AllOf.allOf((Condition[])new Condition[]{ClientJobStreamsAssert.hasJobType(jobType), ClientJobStreamsAssert.isConnectedTo(nodeId)}));
        }

        protected ClientJobStreamsAssert newAbstractIterableAssert(Iterable<? extends JobStreamEndpoint.ClientJobStream> iterable) {
            List<JobStreamEndpoint.ClientJobStream> collection = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            return new ClientJobStreamsAssert(collection);
        }
    }

    public static final class RemoteJobStreamsAssert
    extends AbstractJobStreamsAssert<RemoteJobStreamsAssert, JobStreamEndpoint.RemoteJobStream> {
        public RemoteJobStreamsAssert(Collection<JobStreamEndpoint.RemoteJobStream> actual) {
            super(actual, RemoteJobStreamsAssert.class);
        }

        public RemoteJobStreamsAssert haveConsumerCount(int expectedCount, String jobType, int consumerCount) {
            return (RemoteJobStreamsAssert)this.haveExactly(expectedCount, AllOf.allOf((Condition[])new Condition[]{RemoteJobStreamsAssert.hasJobType(jobType), RemoteJobStreamsAssert.hasConsumerCount(consumerCount)}));
        }

        public RemoteJobStreamsAssert haveConsumerReceiver(int expectedCount, String jobType, String ... receivers) {
            List<String> collection = Arrays.asList(receivers);
            return (RemoteJobStreamsAssert)this.haveExactly(expectedCount, AllOf.allOf((Condition[])new Condition[]{RemoteJobStreamsAssert.hasJobType(jobType), RemoteJobStreamsAssert.hasConsumerReceivers(collection)}));
        }

        protected RemoteJobStreamsAssert newAbstractIterableAssert(Iterable<? extends JobStreamEndpoint.RemoteJobStream> iterable) {
            List<JobStreamEndpoint.RemoteJobStream> collection = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            return new RemoteJobStreamsAssert(collection);
        }
    }
}

