/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.topology;

import io.camunda.zeebe.management.cluster.BrokerStateCode;
import io.camunda.zeebe.management.cluster.CompletedChange;
import io.camunda.zeebe.management.cluster.PartitionStateCode;
import io.camunda.zeebe.management.cluster.PlannedOperationsResponse;
import io.camunda.zeebe.management.cluster.TopologyChange;
import io.camunda.zeebe.qa.util.actuator.ClusterActuator;
import io.camunda.zeebe.qa.util.cluster.TestCluster;
import java.time.OffsetDateTime;
import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;

public final class ClusterActuatorAssert
extends AbstractObjectAssert<ClusterActuatorAssert, ClusterActuator> {
    public ClusterActuatorAssert(ClusterActuator clusterActuator, Class<?> selfType) {
        super((Object)clusterActuator, selfType);
    }

    public static ClusterActuatorAssert assertThat(ClusterActuator actuator) {
        return new ClusterActuatorAssert(actuator, ClusterActuatorAssert.class);
    }

    public static ClusterActuatorAssert assertThat(TestCluster actuator) {
        return new ClusterActuatorAssert(ClusterActuator.of(actuator.anyGateway()), ClusterActuatorAssert.class);
    }

    public ClusterActuatorAssert doesNotHaveBroker(int brokerId) {
        ((ListAssert)Assertions.assertThat((List)((ClusterActuator)this.actual).getTopology().getBrokers()).filteredOn(b -> b.getId() == brokerId)).isEmpty();
        return this;
    }

    public ClusterActuatorAssert hasAppliedChanges(PlannedOperationsResponse response) {
        List expectedTopology = response.getExpectedTopology();
        List currentTopology = ((ClusterActuator)this.actual).getTopology().getBrokers();
        Assertions.assertThat((List)currentTopology).usingRecursiveComparison().ignoringFieldsOfTypes(new Class[]{OffsetDateTime.class}).isEqualTo((Object)expectedTopology);
        return this;
    }

    public ClusterActuatorAssert hasCompletedChanges(PlannedOperationsResponse response) {
        CompletedChange currentChange = ((ClusterActuator)this.actual).getTopology().getLastChange();
        Assertions.assertThat((Object)currentChange).isNotNull();
        Assertions.assertThat((Long)currentChange.getId()).isEqualTo((Object)response.getChangeId());
        Assertions.assertThat((Comparable)currentChange.getStatus()).isEqualTo((Object)CompletedChange.StatusEnum.COMPLETED);
        return this;
    }

    public ClusterActuatorAssert brokerHasPartition(int brokerId, int partitionId) {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)((ClusterActuator)this.actual).getTopology().getBrokers()).filteredOn(b -> b.getId() == brokerId)).singleElement()).matches(b -> b.getPartitions().stream().anyMatch(p -> p.getId() == partitionId), "Broker %d has partition %d".formatted(brokerId, partitionId));
        return this;
    }

    public ClusterActuatorAssert brokerDoesNotHavePartition(int brokerId, int partitionId) {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)((ClusterActuator)this.actual).getTopology().getBrokers()).filteredOn(b -> b.getId() == brokerId)).singleElement()).matches(b -> b.getPartitions().stream().noneMatch(p -> p.getId() == partitionId), "Broker %d does not have partition %d".formatted(brokerId, partitionId));
        return this;
    }

    public ClusterActuatorAssert hasActiveBroker(int brokerId) {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)((ClusterActuator)this.actual).getTopology().getBrokers()).filteredOn(b -> b.getId() == brokerId)).singleElement()).matches(b -> b.getState().equals((Object)BrokerStateCode.ACTIVE), "Cluster does not have broker %d in Active state".formatted(brokerId));
        return this;
    }

    public ClusterActuatorAssert doesNotHavePendingChanges() {
        TopologyChange currentChange = ((ClusterActuator)this.actual).getTopology().getPendingChange();
        Assertions.assertThat((Object)currentChange).isNull();
        return this;
    }

    public ClusterActuatorAssert brokerHasPartitionAtState(int brokerId, int partitionId, PartitionStateCode state) {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)((ClusterActuator)this.actual).getTopology().getBrokers()).filteredOn(b -> b.getId() == brokerId)).singleElement()).matches(b -> b.getPartitions().stream().anyMatch(p -> p.getId() == partitionId && p.getState().equals((Object)state)), "Broker %d has partition %d with state %s".formatted(brokerId, partitionId, state));
        return this;
    }
}

