/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.camunda.zeebe.shared.management.JobStreamEndpoint;
import io.zeebe.containers.ZeebeNode;
import java.util.List;

public interface JobStreamActuator {
    public static JobStreamActuator of(ZeebeNode<?> node) {
        String endpoint = String.format("http://%s/actuator/jobstreams", node.getExternalMonitoringAddress());
        return JobStreamActuator.of(endpoint);
    }

    public static JobStreamActuator of(TestApplication<?> node) {
        return JobStreamActuator.of(node.actuatorUri("jobstreams").toString());
    }

    public static JobStreamActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(JobStreamActuator.class, endpoint);
        JacksonDecoder decoder = new JacksonDecoder(List.of(new Jdk8Module(), new JavaTimeModule()));
        return (JobStreamActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)decoder).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="GET ")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JobStreamEndpoint.JobStreams list();

    @RequestLine(value="GET /client")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<JobStreamEndpoint.ClientJobStream> listClient();

    @RequestLine(value="GET /remote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<JobStreamEndpoint.RemoteJobStream> listRemote();
}

