/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import com.google.common.collect.ObjectArrays;
import io.atomix.cluster.MemberId;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestHealthProbe;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import io.camunda.zeebe.shared.Profile;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;

public interface TestApplication<T extends TestApplication<T>>
extends AutoCloseable {
    public T start();

    public T stop();

    public boolean isStarted();

    @Override
    default public void close() {
        this.stop();
    }

    public T self();

    public <V> T withBean(String var1, V var2, Class<V> var3);

    public MemberId nodeId();

    default public String host() {
        return "localhost";
    }

    default public int mappedPort(TestZeebePort port) {
        return port.port();
    }

    default public String address(int port) {
        return this.host() + ":" + port;
    }

    default public String address(TestZeebePort port) {
        return this.address(this.mappedPort(port));
    }

    default public URI uri(String scheme, TestZeebePort port, String ... paths) {
        return this.uri(scheme, port, List.of(paths));
    }

    default public URI uri(String scheme, TestZeebePort port, SequencedCollection<String> paths) {
        try {
            String path = paths.stream().filter(Predicate.not(Objects::isNull)).map(String::trim).map(p -> p.replaceFirst("^\\/", "")).filter(Predicate.not(String::isBlank)).collect(Collectors.joining("/"));
            return new URI(scheme + "://" + this.address(port) + "/" + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse URI", e);
        }
    }

    default public URI monitoringUri(String ... paths) {
        String serverBasePath = this.property("management.server.base-path", String.class, "");
        Boolean sslEnabled = this.property("management.server.ssl.enabled", Boolean.class, false);
        return this.uri(sslEnabled != false ? "https" : "http", TestZeebePort.MONITORING, (String[])ObjectArrays.concat((Object)serverBasePath, (Object[])paths));
    }

    default public URI actuatorUri(String ... paths) {
        String actuatorBasePath = this.property("management.endpoints.web.base-path", String.class, "/actuator");
        return this.monitoringUri((String[])ObjectArrays.concat((Object)actuatorBasePath, (Object[])paths));
    }

    public HealthActuator healthActuator();

    default public void probe(TestHealthProbe probe) {
        switch (probe) {
            case LIVE: {
                this.healthActuator().live();
                break;
            }
            case READY: {
                this.healthActuator().ready();
                break;
            }
            case STARTED: {
                this.healthActuator().startup();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)probe));
            }
        }
    }

    public boolean isGateway();

    default public T await(TestHealthProbe probe, Duration timeout) {
        Awaitility.await((String)"until broker '%s' is '%s'".formatted(new Object[]{this.nodeId(), probe})).atMost(timeout).untilAsserted(() -> Assertions.assertThatCode(() -> this.probe(probe)).doesNotThrowAnyException());
        return this.self();
    }

    default public T await(TestHealthProbe probe) {
        return this.await(probe, Duration.ofSeconds(30L));
    }

    public <V> V bean(Class<V> var1);

    public <V> V property(String var1, Class<V> var2, V var3);

    public T withProperty(String var1, Object var2);

    public T withAdditionalProfile(String var1);

    default public T withAdditionalProfile(Profile profile) {
        return this.withAdditionalProfile(profile.getId());
    }
}

