/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.response.Topology;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.qa.util.actuator.GatewayHealthActuator;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.camunda.zeebe.qa.util.cluster.TestZeebePort;
import io.camunda.zeebe.test.util.asserts.TopologyAssert;
import java.net.URI;
import java.time.Duration;
import java.util.function.Consumer;
import org.awaitility.Awaitility;

public interface TestGateway<T extends TestGateway<T>>
extends TestApplication<T> {
    default public URI grpcAddress() {
        String scheme = this.gatewayConfig().getSecurity().isEnabled() ? "https" : "http";
        return this.uri(scheme, TestZeebePort.GATEWAY, new String[0]);
    }

    default public URI restAddress() {
        String basePath = this.property("spring.webflux.base-path", String.class, "");
        Boolean sslEnabled = this.property("server.ssl.enabled", Boolean.class, false);
        return this.uri(sslEnabled != false ? "https" : "http", TestZeebePort.REST, basePath);
    }

    default public GatewayHealthActuator gatewayHealth() {
        return GatewayHealthActuator.of(this);
    }

    @Override
    default public HealthActuator healthActuator() {
        return this.gatewayHealth();
    }

    @Override
    default public boolean isGateway() {
        return true;
    }

    public T withGatewayConfig(Consumer<GatewayCfg> var1);

    public GatewayCfg gatewayConfig();

    default public ZeebeClientBuilder newClientBuilder() {
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().grpcAddress(this.grpcAddress()).restAddress(this.restAddress());
        SecurityCfg security = this.gatewayConfig().getSecurity();
        Boolean restSSL = this.property("server.ssl.enabled", Boolean.class, false);
        if (security.isEnabled() || restSSL.booleanValue()) {
            builder.caCertificatePath(security.getCertificateChainPath().getAbsolutePath());
        } else {
            builder.usePlaintext();
        }
        return builder;
    }

    default public T awaitCompleteTopology(int clusterSize, int partitionCount, int replicationFactor, Duration timeout) {
        try (ZeebeClient client = this.newClientBuilder().build();){
            Awaitility.await((String)"until cluster topology is complete").atMost(timeout).untilAsserted(() -> TopologyAssert.assertThat((Topology)((Topology)client.newTopologyRequest().send().join())).isComplete(clusterSize, partitionCount, replicationFactor));
        }
        return (T)((TestGateway)this.self());
    }

    default public T awaitCompleteTopology() {
        return this.awaitCompleteTopology(1, 1, 1, Duration.ofSeconds(30L));
    }
}

