/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.jobstream;

import io.camunda.zeebe.shared.management.JobStreamEndpoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.condition.AllOf;
import org.assertj.core.condition.VerboseCondition;

public abstract class AbstractJobStreamsAssert<SELF extends AbstractJobStreamsAssert<SELF, T>, T extends JobStreamEndpoint.JobStream>
extends AbstractCollectionAssert<SELF, Collection<T>, T, ObjectAssert<T>> {
    public AbstractJobStreamsAssert(Collection<T> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF haveJobType(int expectedCount, String jobType) {
        return (SELF)((Object)((AbstractJobStreamsAssert)this.haveExactly(expectedCount, AbstractJobStreamsAssert.hasJobType(jobType))));
    }

    public SELF haveWorker(int expectedCount, String worker) {
        return (SELF)((Object)((AbstractJobStreamsAssert)this.haveExactly(expectedCount, AbstractJobStreamsAssert.hasWorker(worker))));
    }

    public SELF doNotHaveWorker(String worker) {
        return (SELF)((Object)((AbstractJobStreamsAssert)this.doNotHave(AbstractJobStreamsAssert.hasWorker(worker))));
    }

    @SafeVarargs
    public final SELF haveExactlyAll(int expectedCount, Condition<? super T> ... conditions) {
        return (SELF)((Object)((AbstractJobStreamsAssert)this.haveExactly(expectedCount, AllOf.allOf(conditions))));
    }

    public SELF doNotHaveJobType(String jobType) {
        return (SELF)((Object)((AbstractJobStreamsAssert)this.doNotHave(AbstractJobStreamsAssert.hasJobType(jobType))));
    }

    protected ObjectAssert<T> toAssert(T value, String description) {
        return (ObjectAssert)Assertions.assertThat(value).as(description, new Object[0]);
    }

    public static <T extends JobStreamEndpoint.JobStream> Condition<T> hasJobType(String streamType) {
        return VerboseCondition.verboseCondition(stream -> stream.jobType().equals(streamType), (String)"a stream with type '%s'".formatted(streamType), stream -> " but actual type is '%s'".formatted(stream.jobType()));
    }

    public static <T extends JobStreamEndpoint.JobStream> Condition<T> hasWorker(String workerName) {
        return VerboseCondition.verboseCondition(stream -> stream.metadata().worker().equals(workerName), (String)"a stream with worker '%s'".formatted(workerName), stream -> " but actual worker is '%s'".formatted(stream.metadata().worker()));
    }

    public static Condition<JobStreamEndpoint.ClientJobStream> isConnectedTo(int ... nodeId) {
        Set members = Arrays.stream(nodeId).boxed().collect(Collectors.toSet());
        return VerboseCondition.verboseCondition(stream -> stream.connectedTo().containsAll(members), (String)"a stream connected to brokers %s".formatted(Arrays.toString(nodeId)), stream -> " but actual connections are '%s'".formatted(stream.connectedTo()));
    }

    public static <T extends JobStreamEndpoint.JobStream> Condition<T> hasTimeout(long timeoutMillis) {
        return VerboseCondition.verboseCondition(stream -> stream.metadata().timeout().toMillis() == timeoutMillis, (String)"a stream with timeout '%dms'".formatted(timeoutMillis), stream -> " but actual timeout is '%s'".formatted(stream.metadata().timeout()));
    }

    public static <T extends JobStreamEndpoint.JobStream> Condition<T> hasFetchVariables(String ... variables) {
        List<String> expectedVariables = Arrays.asList(variables);
        return VerboseCondition.verboseCondition(stream -> stream.metadata().fetchVariables().containsAll(expectedVariables) && stream.metadata().fetchVariables().size() == expectedVariables.size(), (String)"a stream with fetch variables %s".formatted(Arrays.toString(variables)), stream -> " but actual variables is %s".formatted(stream.metadata().fetchVariables()));
    }

    public static Condition<JobStreamEndpoint.RemoteJobStream> hasConsumerCount(int count) {
        return VerboseCondition.verboseCondition(stream -> stream.consumers().size() == count, (String)"a stream with '%d' consumers".formatted(count), stream -> " but actual consumers are '%s'".formatted(stream.consumers()));
    }

    public static Condition<JobStreamEndpoint.RemoteJobStream> hasConsumerReceivers(Collection<String> receivers) {
        return VerboseCondition.verboseCondition(stream -> stream.consumers().size() == receivers.size() && stream.consumers().stream().map(JobStreamEndpoint.RemoteStreamId::receiver).collect(Collectors.toSet()).containsAll(receivers), (String)"a stream with consumer receivers '%s'".formatted(receivers), stream -> " but actual consumers are '%s'".formatted(stream.consumers()));
    }
}

