/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.junit;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.camunda.zeebe.qa.util.cluster.TestCluster;
import io.camunda.zeebe.qa.util.cluster.TestGateway;
import io.camunda.zeebe.qa.util.cluster.TestHealthProbe;
import io.camunda.zeebe.qa.util.cluster.TestStandaloneBroker;
import io.camunda.zeebe.qa.util.junit.ZeebeIntegration;
import io.camunda.zeebe.test.util.record.RecordLogger;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.ReflectUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.function.Predicate;
import org.agrona.CloseHelper;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZeebeIntegrationExtension
implements BeforeAllCallback,
BeforeEachCallback,
TestWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeIntegrationExtension.class);

    ZeebeIntegrationExtension() {
    }

    public void beforeAll(ExtensionContext extensionContext) {
        Iterable<ClusterResource> resources = this.lookupClusters(extensionContext, null, ModifierSupport::isStatic);
        Iterable<ApplicationResource> nodes = this.lookupApplications(extensionContext, null, ModifierSupport::isStatic);
        this.manageClusters(extensionContext, resources);
        this.manageApplications(extensionContext, nodes);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        Object testInstance = extensionContext.getRequiredTestInstance();
        Iterable<ClusterResource> clusters = this.lookupClusters(extensionContext, testInstance, ModifierSupport::isNotStatic);
        Iterable<ApplicationResource> nodes = this.lookupApplications(extensionContext, testInstance, ModifierSupport::isNotStatic);
        this.manageClusters(extensionContext, clusters);
        this.manageApplications(extensionContext, nodes);
        RecordingExporter.reset();
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        RecordLogger.logRecords();
    }

    private Iterable<ClusterResource> lookupClusters(ExtensionContext extensionContext, Object testInstance, Predicate<Field> fieldType) {
        return AnnotationSupport.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), ZeebeIntegration.TestZeebe.class, fieldType.and(field -> ReflectionUtils.isAssignableTo(field.getType(), TestCluster.class)), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream().map(field -> this.asClusterResource(testInstance, (Field)field)).toList();
    }

    private Iterable<ApplicationResource> lookupApplications(ExtensionContext extensionContext, Object testInstance, Predicate<Field> fieldType) {
        return AnnotationSupport.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), ZeebeIntegration.TestZeebe.class, fieldType.and(field -> ReflectionUtils.isAssignableTo(field.getType(), TestApplication.class)), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream().map(field -> this.asNodeResource(testInstance, (Field)field)).toList();
    }

    private void manageClusters(ExtensionContext extensionContext, Iterable<ClusterResource> resources) {
        ExtensionContext.Store store = this.store(extensionContext);
        resources.forEach(resource -> store.put(resource, resource));
        for (ClusterResource resource2 : resources) {
            Path directory = this.createManagedDirectory(store, resource2.cluster().name());
            this.manageCluster(directory, resource2);
        }
    }

    private void manageCluster(Path directory, ClusterResource resource) {
        TestCluster cluster = resource.cluster();
        cluster.brokers().forEach((id, broker) -> this.setWorkingDirectory(directory, (MemberId)id, (TestStandaloneBroker)broker));
        this.startTestZeebe(resource);
    }

    private void manageApplications(ExtensionContext extensionContext, Iterable<ApplicationResource> resources) {
        ExtensionContext.Store store = this.store(extensionContext);
        resources.forEach(resource -> store.put(resource, resource));
        for (ApplicationResource resource2 : resources) {
            this.manageApplication(store, resource2);
        }
    }

    private void manageApplication(ExtensionContext.Store store, ApplicationResource resource) {
        TestApplication<?> testApplication = resource.app();
        if (testApplication instanceof TestStandaloneBroker) {
            TestStandaloneBroker broker = (TestStandaloneBroker)testApplication;
            Path directory = this.createManagedDirectory(store, "broker-" + (String)((Object)broker.nodeId().id()));
            this.setWorkingDirectory(directory, broker.nodeId(), broker);
        }
        this.startTestZeebe(resource);
    }

    private void startTestZeebe(TestZeebeResource resource) {
        ZeebeIntegration.TestZeebe annotation = resource.annotation();
        if (annotation.autoStart()) {
            resource.start();
            if (annotation.awaitStarted()) {
                resource.await(TestHealthProbe.STARTED);
            }
            if (annotation.awaitReady()) {
                resource.await(TestHealthProbe.READY);
            }
            if (annotation.awaitCompleteTopology()) {
                resource.awaitCompleteTopology();
            }
        }
    }

    private void setWorkingDirectory(Path directory, MemberId id, TestStandaloneBroker broker) {
        Path workingDirectory = directory.resolve("broker-" + (String)((Object)id.id()));
        try {
            Files.createDirectory(workingDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        broker.withWorkingDirectory(workingDirectory);
    }

    private Path createManagedDirectory(ExtensionContext.Store store, String prefix) {
        try {
            Path directory = Files.createTempDirectory("junit-" + prefix, new FileAttribute[0]);
            store.put((Object)directory, (Object)new DirectoryResource(directory));
            return directory;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ClusterResource asClusterResource(Object testInstance, Field field) {
        ReflectUtil.makeAccessible((AccessibleObject)field, (Object)testInstance);
        return new ClusterResource(testInstance, field, field.getAnnotation(ZeebeIntegration.TestZeebe.class));
    }

    private ApplicationResource asNodeResource(Object testInstance, Field field) {
        ReflectUtil.makeAccessible((AccessibleObject)field, (Object)testInstance);
        return new ApplicationResource(testInstance, field, field.getAnnotation(ZeebeIntegration.TestZeebe.class));
    }

    private ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ZeebeIntegrationExtension.class}));
    }

    private record ClusterResource(Object testInstance, Field field, ZeebeIntegration.TestZeebe annotation) implements TestZeebeResource,
    ExtensionContext.Store.CloseableResource
    {
        public TestCluster cluster() {
            try {
                return (TestCluster)this.field.get(this.testInstance);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void close() {
            CloseHelper.close(error -> LOG.warn("Failed to close cluster {}, leaking resources", (Object)this.cluster().name(), (Object)error), (AutoCloseable)((Object)this.cluster()));
        }

        @Override
        public void start() {
            this.cluster().start();
        }

        @Override
        public void await(TestHealthProbe probe) {
            this.cluster().await(probe);
        }

        @Override
        public void awaitCompleteTopology() {
            int clusterSize = this.annotation.clusterSize() <= 0 ? this.cluster().brokers().size() : this.annotation.clusterSize();
            int partitionCount = this.annotation.partitionCount() <= 0 ? this.cluster().partitionsCount() : this.annotation.partitionCount();
            int replicationFactor = this.annotation.replicationFactor() <= 0 ? this.cluster().replicationFactor() : this.annotation.replicationFactor();
            Duration timeout = this.annotation.topologyTimeoutMs() == 0L ? Duration.ofMinutes(clusterSize) : Duration.ofMillis(this.annotation().topologyTimeoutMs());
            this.cluster().awaitCompleteTopology(clusterSize, partitionCount, replicationFactor, timeout);
        }
    }

    private static interface TestZeebeResource {
        public ZeebeIntegration.TestZeebe annotation();

        public void start();

        public void await(TestHealthProbe var1);

        public void awaitCompleteTopology();
    }

    private record ApplicationResource(Object testInstance, Field field, ZeebeIntegration.TestZeebe annotation) implements TestZeebeResource,
    ExtensionContext.Store.CloseableResource
    {
        public TestApplication<?> app() {
            try {
                return (TestApplication)this.field.get(this.testInstance);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void close() {
            CloseHelper.close(error -> LOG.warn("Failed to close test app {}, leaking resources", (Object)this.app().nodeId()), this.app());
        }

        @Override
        public void start() {
            this.app().start();
        }

        @Override
        public void await(TestHealthProbe probe) {
            this.app().await(probe);
        }

        @Override
        public void awaitCompleteTopology() {
            TestApplication<?> testApplication;
            if (!this.app().isGateway() || !((testApplication = this.app()) instanceof TestGateway)) {
                return;
            }
            TestGateway gateway = (TestGateway)testApplication;
            Duration timeout = this.annotation.topologyTimeoutMs() == 0L ? Duration.ofMinutes(1L) : Duration.ofMillis(this.annotation().topologyTimeoutMs());
            gateway.awaitCompleteTopology(Math.max(1, this.annotation.clusterSize()), Math.max(1, this.annotation.partitionCount()), Math.max(1, this.annotation.replicationFactor()), timeout);
        }
    }

    private record DirectoryResource(Path directory) implements ExtensionContext.Store.CloseableResource
    {
        public void close() {
            try {
                FileUtil.deleteFolderIfExists((Path)this.directory);
            }
            catch (IOException e) {
                LOG.warn("Failed to clean up temporary directory {}, leaking resources...", (Object)this.directory, (Object)e);
            }
        }
    }
}

