/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.boundary;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstances;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class BoundaryEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final BpmnModelInstance MULTIPLE_SEQUENCE_FLOWS = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("timer").cancelActivity(Boolean.valueOf(true))).timerWithDurationExpression("duration(\"PT0.1S\")")).endEvent("end1").moveToNode("timer").endEvent("end2").moveToActivity("task").endEvent().done();
    private static final BpmnModelInstance NON_INTERRUPTING_PROCESS = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("event").cancelActivity(Boolean.valueOf(false))).timerWithCycleExpression("cycle(duration(\"PT1S\"))")).endEvent().done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldTakeAllOutgoingSequenceFlowsIfTriggered() {
        ENGINE.deployment().withXmlResource(MULTIPLE_SEQUENCE_FLOWS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((TimerRecordStream)RecordingExporter.timerRecords().withHandlerNodeId("timer").withIntent((Intent)TimerIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withElementType(BpmnElementType.END_EVENT).withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getValue).extracting(ProcessInstanceRecordValue::getElementId).contains((Object[])new String[]{"end1", "end2"});
    }

    @Test
    public void shouldActivateBoundaryEventWhenEventTriggered() {
        ENGINE.deployment().withXmlResource(MULTIPLE_SEQUENCE_FLOWS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((TimerRecordStream)RecordingExporter.timerRecords().withHandlerNodeId("timer").withIntent((Intent)TimerIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withType("type").withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        List records = ((RecordStream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).limit(r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("timer") && r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATING)).asList();
        Assertions.assertThat((List)records).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.TIMER, TimerIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{ValueType.JOB, JobIntent.CANCEL}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATING})});
    }

    @Test
    public void shouldApplyOutputMappingOnTriggering() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("event").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).zeebeOutputExpression("foo", "bar")).endEvent("endTimer").moveToActivity("task").endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        ENGINE.message().withName("message").withCorrelationKey("123").withVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)3)).publish();
        Record variableEvent = (Record)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withName("bar").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableEvent.getValue())).hasValue("3");
    }

    @Test
    public void shouldUseScopeVariablesWhenApplyingOutputMappings() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", b -> ((ServiceTaskBuilder)b.zeebeJobType("type")).zeebeInputExpression("oof", "baz")).boundaryEvent("timer").cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT1S")).endEvent("endTimer").moveToActivity("task").endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"foo\": 1, \"oof\": 2 }").create();
        ((TimerRecordStream)RecordingExporter.timerRecords().withHandlerNodeId("timer").withIntent((Intent)TimerIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        Record boundaryTriggered = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("timer").withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Map variables = ProcessInstances.getCurrentVariables((long)processInstanceKey, (long)boundaryTriggered.getPosition());
        Assertions.assertThat((Map)variables).contains(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"1"), Assertions.entry((Object)"oof", (Object)"2")});
    }

    @Test
    public void shouldTerminateSubProcessBeforeTriggeringBoundaryEvent() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub").embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType("type")).endEvent().subProcessDone().boundaryEvent("timer").cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT1S")).endEvent("endTimer").moveToActivity("sub").endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((JobRecordStream)RecordingExporter.jobRecords().withIntent((Intent)JobIntent.CREATED)).getFirst();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        List records = ((RecordStream)RecordingExporter.records().limit(r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("timer") && r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED)).asList();
        Assertions.assertThat((List)records).extracting(new Function[]{Record::getValueType, Record::getIntent}).endsWith((Object)Assertions.tuple((Object[])new Object[]{ValueType.TIMER, TimerIntent.TRIGGERED}), (Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_EVENT, ProcessEventIntent.TRIGGERING}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{ValueType.JOB, JobIntent.CANCEL}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_EVENT, ProcessEventIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{ValueType.JOB, JobIntent.CANCELED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldNotTerminateActivityForNonInterruptingBoundaryEvents() {
        ENGINE.deployment().withXmlResource(NON_INTERRUPTING_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((JobRecordStream)RecordingExporter.jobRecords().withType("type").withIntent((Intent)JobIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        ((TimerRecordStream)RecordingExporter.timerRecords().withHandlerNodeId("event").withIntent((Intent)TimerIntent.TRIGGER)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.job().ofInstance(processInstanceKey).withType("type").complete();
        List records = ((RecordStream)RecordingExporter.records().limit(r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("task") && r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED)).asList();
        Assertions.assertThat((List)records).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.TIMER, TimerIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.TIMER, TimerIntent.CREATED}), Assertions.tuple((Object[])new Object[]{ValueType.JOB, JobIntent.COMPLETED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ValueType.TIMER, TimerIntent.CANCEL}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldUseScopeToExtractCorrelationKeys() {
        String processId = "shouldHaveScopeKeyIfBoundaryEvent";
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldHaveScopeKeyIfBoundaryEvent").startEvent().serviceTask("task", c -> ((ServiceTaskBuilder)c.zeebeJobType("type")).zeebeInputExpression("bar", "foo")).boundaryEvent("event", b -> b.message(m -> m.zeebeCorrelationKeyExpression("foo").name("message"))).endEvent().moveToActivity("task").endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldHaveScopeKeyIfBoundaryEvent").withVariables("{'foo':1,'bar':2}").create();
        ENGINE.message().withName("message").withCorrelationKey("1").publish();
        Assertions.assertThat((Object)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BOUNDARY_EVENT).getFirst())).isNotNull();
    }

    @Test
    public void shouldHaveScopeKeyIfBoundaryEvent() {
        String processId = "shouldHaveScopeKeyIfBoundaryEvent";
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldHaveScopeKeyIfBoundaryEvent").startEvent().serviceTask("task", c -> c.zeebeJobType("type")).boundaryEvent("event", b -> b.message(m -> m.zeebeCorrelationKeyExpression("orderId").name("message"))).endEvent().moveToActivity("task").endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldHaveScopeKeyIfBoundaryEvent").withVariable("orderId", true).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasProcessInstanceKey(processInstanceKey)).hasElementId("task")).hasElementInstanceKey(failureEvent.getKey())).hasJobKey(-1L)).hasVariableScopeKey(processInstanceKey);
    }
}

