/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.error;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ErrorCatchEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String TASK_ELEMENT_ID = "task";
    private static final String PROCESS_ID = "wf";
    private static final String JOB_TYPE = "test";
    private static final String ERROR_CODE = "ERROR";
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public BpmnModelInstance process;
    @Parameterized.Parameter(value=2)
    public String expectedActivatedElement;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        return new Object[][]{{"boundary event on service task", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done(), "error-boundary-event"}, {"boundary event on subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).endEvent()).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done(), "error-boundary-event"}, {"boundary event on multi-instance subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.multiInstance(m -> m.zeebeInputCollectionExpression("[1]"))).embeddedSubProcess().startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).endEvent()).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done(), "error-boundary-event"}, {"boundary event on multi-instance service task", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(TASK_ELEMENT_ID, t -> ((ServiceTaskBuilder)t.zeebeJobType(JOB_TYPE)).multiInstance(m -> m.zeebeInputCollectionExpression("[1]"))).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done(), "error-boundary-event"}, {"error event subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("error-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent("error-start-event").error(ERROR_CODE)).interrupting(true)).endEvent()).startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).endEvent().done(), "error-event-subprocess"}, {"favor boundary event on task over boundary event on subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent()).boundaryEvent("error-boundary-event-on-subprocess", b -> b.error(ERROR_CODE)).endEvent().done(), "error-boundary-event"}, {"favor boundary event on task over error event subprocess", ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("error-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().error(ERROR_CODE)).interrupting(true)).endEvent()).startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).boundaryEvent("error-boundary-event").error(ERROR_CODE)).endEvent().done(), "error-boundary-event"}, {"favor error event subprocess over boundary event on subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub", s -> s.embeddedSubProcess().eventSubProcess("error-event-subprocess", e -> ((StartEventBuilder)((StartEventBuilder)e.startEvent("error-start-event").error(ERROR_CODE)).interrupting(true)).endEvent()).startEvent().serviceTask(TASK_ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).endEvent()).boundaryEvent("error", b -> b.error(ERROR_CODE)).endEvent().done(), "error-event-subprocess"}};
    }

    @Test
    public void shouldTriggerEvent() {
        ENGINE.deployment().withXmlResource(this.process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TASK_ELEMENT_ID, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{TASK_ELEMENT_ID, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{this.expectedActivatedElement, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{this.expectedActivatedElement, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

