/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ParallelGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.ServiceTask;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public final class ParallelGatewayTest {
    private static final String PROCESS_ID = "process";
    private static final BpmnModelInstance FORK_PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent("start").parallelGateway("fork").serviceTask("task1", b -> b.zeebeJobType("type1")).endEvent("end1").moveToNode("fork").serviceTask("task2", b -> b.zeebeJobType("type2")).endEvent("end2").done();
    private static final BpmnModelInstance FORK_JOIN_PROCESS = ((ParallelGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").parallelGateway("fork").sequenceFlowId("flow1")).parallelGateway("join").endEvent("end").moveToNode("fork").sequenceFlowId("flow2").connectTo("join").done();
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    @Test
    public void shouldActivateTasksOnParallelBranches() {
        this.engine.deployment().withXmlResource(FORK_PROCESS).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List taskEvents = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).filter(e -> ParallelGatewayTest.isServiceTaskInProcess(((ProcessInstanceRecordValue)e.getValue()).getElementId(), FORK_PROCESS))).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((List)taskEvents).hasSize(2);
        Assertions.assertThat((List)taskEvents).extracting(e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId()).containsExactlyInAnyOrder((Object[])new String[]{"task1", "task2"});
        Assertions.assertThat((long)((Record)taskEvents.get(0)).getKey()).isNotEqualTo(((Record)taskEvents.get(1)).getKey());
    }

    @Test
    public void shouldCompleteScopeWhenAllPathsCompleted() {
        this.engine.deployment().withXmlResource(FORK_PROCESS).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.engine.job().ofInstance(processInstanceKey).withType("type1").complete();
        this.engine.job().ofInstance(processInstanceKey).withType("type2").complete();
        List completedEvents = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((List)completedEvents).extracting(e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId()).containsExactly((Object[])new String[]{"end1", "end2"});
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId(PROCESS_ID).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).getFirst();
    }

    @Test
    public void shouldCompleteScopeWithMultipleTokensOnSamePath() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").exclusiveGateway("join").endEvent("end").moveToNode("fork").connectTo("join").done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List processInstanceEvents = (List)RecordingExporter.processInstanceRecords().limitToProcessInstanceCompleted().collect(Collectors.toList());
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldPassThroughParallelGateway() {
        BpmnModelInstance process = ((ParallelGatewayBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").sequenceFlowId("flow1")).parallelGateway("fork").sequenceFlowId("flow2")).endEvent("end").done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List processInstanceEvents = (List)RecordingExporter.processInstanceRecords().limitToProcessInstanceCompleted().collect(Collectors.toList());
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"fork", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"fork", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"fork", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"fork", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"flow2", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCompleteScopeOnParallelGateway() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").sequenceFlowId("flow1")).parallelGateway("fork").done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List processInstanceEvents = (List)RecordingExporter.processInstanceRecords().limitToProcessInstanceCompleted().collect(Collectors.toList());
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"fork", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.COMPLETE_ELEMENT})});
    }

    @Test
    public void shouldMergeParallelBranches() {
        this.engine.deployment().withXmlResource(FORK_JOIN_PROCESS).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List events = (List)RecordingExporter.processInstanceRecords().limitToProcessInstanceCompleted().collect(Collectors.toList());
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)events).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"flow1", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"join", ProcessInstanceIntent.ELEMENT_ACTIVATING})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"flow2", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"join", ProcessInstanceIntent.ELEMENT_ACTIVATING})})).containsOnlyOnce((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"join", ProcessInstanceIntent.ELEMENT_ACTIVATING})});
    }

    @Test
    public void shouldOnlyTriggerGatewayWhenAllBranchesAreActivated() {
        BpmnModelInstance process = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").exclusiveGateway("exclusiveJoin").moveToLastGateway().connectTo("exclusiveJoin").sequenceFlowId("joinFlow1").parallelGateway("join").moveToNode("fork").serviceTask("waitState", b -> b.zeebeJobType("type")).sequenceFlowId("joinFlow2")).connectTo("join").endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().limit(r -> "joinFlow1".equals(((ProcessInstanceRecordValue)r.getValue()).getElementId()))).limit(2L)).skip(1L)).getFirst();
        this.engine.job().ofInstance(processInstanceKey).withType("type").complete();
        List events = (List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().limit(r -> "join".equals(((ProcessInstanceRecordValue)r.getValue()).getElementId()) && ProcessInstanceIntent.ELEMENT_COMPLETED == r.getIntent())).collect(Collectors.toList());
        Assertions.assertThat((List)events).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"joinFlow1", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"joinFlow1", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"joinFlow2", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"join", ProcessInstanceIntent.ELEMENT_ACTIVATING})});
    }

    @Test
    public void shouldMergeAndSplitInOneGateway() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").parallelGateway("fork").parallelGateway("join-fork").moveToNode("fork").connectTo("join-fork").serviceTask("task1", b -> b.zeebeJobType("type1")).moveToLastGateway().serviceTask("task2", b -> b.zeebeJobType("type2")).done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List elementInstances = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATED && ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() == BpmnElementType.SERVICE_TASK)).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((List)elementInstances).extracting(e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId()).contains((Object[])new String[]{"task1", "task2"});
    }

    @Test
    public void shouldSplitWithUncontrolledFlow() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").serviceTask("task1", b -> b.zeebeJobType("type1")).moveToNode("start").serviceTask("task2", b -> b.zeebeJobType("type2")).done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List taskEvents = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).filter(e -> ParallelGatewayTest.isServiceTaskInProcess(((ProcessInstanceRecordValue)e.getValue()).getElementId(), process))).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((List)taskEvents).hasSize(2);
        Assertions.assertThat((List)taskEvents).extracting(e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId()).containsExactlyInAnyOrder((Object[])new String[]{"task1", "task2"});
        Assertions.assertThat((long)((Record)taskEvents.get(0)).getKey()).isNotEqualTo(((Record)taskEvents.get(1)).getKey());
    }

    private static boolean isServiceTaskInProcess(String activityId, BpmnModelInstance process) {
        return process.getModelElementsByType(ServiceTask.class).stream().anyMatch(t -> t.getId().equals(activityId));
    }
}

