/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.subprocess;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class InterruptingEventSubprocessConcurrencyTest {
    private static final String PROCESS_ID = "proc";
    private static final String MSG_NAME = "messageName";
    @Rule
    public final EngineRule engineRule = EngineRule.singlePartition();

    @Test
    public void shouldEndProcess() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)PROCESS_ID);
        ((StartEventBuilder)((StartEventBuilder)process.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(true)).message(b -> b.name(MSG_NAME).zeebeCorrelationKeyExpression("key"))).endEvent("event_sub_end");
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)process.startEvent("start_proc").intermediateCatchEvent("catch").message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).exclusiveGateway().endEvent("end_proc").done();
        this.engineRule.deployment().withXmlResource(model).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("key", 123)).create();
        Record intermediateSubscriptionCreated = (Record)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("msg").getFirst();
        Record eventSubprocessSubscriptionCreated = (Record)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName(MSG_NAME).getFirst();
        this.engineRule.writeRecords(RecordToWrite.command().processMessageSubscription(ProcessMessageSubscriptionIntent.CORRELATE, (ProcessMessageSubscriptionRecordValue)intermediateSubscriptionCreated.getValue()), RecordToWrite.command().processMessageSubscription(ProcessMessageSubscriptionIntent.CORRELATE, (ProcessMessageSubscriptionRecordValue)eventSubprocessSubscriptionCreated.getValue()));
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldEndProcessWithParallelFlow() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)PROCESS_ID);
        ((StartEventBuilder)((StartEventBuilder)process.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(true)).message(b -> b.name(MSG_NAME).zeebeCorrelationKeyExpression("key"))).endEvent("event_sub_end");
        BpmnModelInstance model = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((StartEventBuilder)process.startEvent("start_proc").sequenceFlowId("toParallel")).parallelGateway("parallel").intermediateCatchEvent("catch").message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).endEvent("end_proc").moveToLastGateway().intermediateCatchEvent("catch1").message(m -> m.name("msg1").zeebeCorrelationKeyExpression("key1"))).endEvent("end_proc1").done();
        this.engineRule.deployment().withXmlResource(model).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("key", 123, "key1", 123)).create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName(MSG_NAME).await();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.START_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementId("start_proc").withProcessInstanceKey(processInstanceKey).await();
        this.engineRule.message().withName(MSG_NAME).withCorrelationKey("123").withVariables(Map.of("key", "123")).publish();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldTerminateXorWithIncident() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)PROCESS_ID);
        ((StartEventBuilder)((StartEventBuilder)process.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(true)).message(b -> b.name(MSG_NAME).zeebeCorrelationKeyExpression("key"))).endEvent("event_sub_end");
        BpmnModelInstance model = ((ExclusiveGatewayBuilder)((StartEventBuilder)process.startEvent("start_proc").sequenceFlowId("toXor")).exclusiveGateway("xor").condition("=yolo")).endEvent().done();
        this.engineRule.deployment().withXmlResource(model).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("key", 123, "key1", 123)).create();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        this.engineRule.message().withName(MSG_NAME).withCorrelationKey("123").withVariables(Map.of("key", "123")).publish();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

