/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.subprocess;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.EmbeddedSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.MessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class MultipleEventSubprocessTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "proc";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldTriggerMultipleEventSubprocesses() {
        BpmnModelInstance model = this.twoEventSubprocModel(false, false, this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        this.triggerTimerStart(processInstanceKey);
        this.triggerMessageStart(processInstanceKey, this.helper.getMessageName());
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).withElementId("event_sub_proc_timer").await();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).withElementId("event_sub_proc_msg").await();
    }

    @Test
    public void shouldInterruptOtherActiveEventSubprocess() {
        BpmnModelInstance model = this.twoEventSubprocWithTasksModel(false, true, this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        this.triggerTimerStart(processInstanceKey);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("event_sub_task_timer").exists()).describedAs("Expected service task after timer start event to exist", new Object[0])).isTrue();
        this.triggerMessageStart(processInstanceKey, this.helper.getMessageName());
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limitToProcessInstanceCompleted()).extracting(r -> Tuple.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getElementId(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"event_sub_proc_timer", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"event_sub_task_timer", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"event_sub_proc_timer", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{"event_sub_task_timer", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{"event_sub_proc_timer", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{"event_sub_proc_msg", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"event_sub_proc_msg", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCloseEventSubscriptionWhenScopeCloses() {
        BpmnModelInstance model = MultipleEventSubprocessTest.nestedMsgModel(this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).exists()).describedAs("Expected event subprocess message start subscription to be opened.", new Object[0])).isTrue();
        MultipleEventSubprocessTest.completeJob(processInstanceKey, "sub_proc_type");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withMessageName(this.helper.getMessageName()).exists()).describedAs("Expected event subprocess start message subscription to be closed.", new Object[0])).isTrue();
    }

    @Test
    public void shouldCorrelateTwoMessagesIfNonInterrupting() {
        BpmnModelInstance model = this.twoEventSubprocWithTasksModel(false, false, this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        this.triggerMessageStart(processInstanceKey, this.helper.getMessageName());
        this.triggerMessageStart(processInstanceKey, this.helper.getMessageName());
        Assertions.assertThat((long)((MessageSubscriptionRecordStream)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CORRELATED).withProcessInstanceKey(processInstanceKey).limit(2L)).count()).isEqualTo(2L);
    }

    @Test
    public void shouldKeepProcessInstanceActive() {
        BpmnModelInstance model = this.twoEventSubprocWithTasksModel(false, false, this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        this.triggerTimerStart(processInstanceKey);
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withType("timerTask").await();
        MultipleEventSubprocessTest.completeJob(processInstanceKey, "type");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withElementId("end_proc").await();
        MultipleEventSubprocessTest.completeJob(processInstanceKey, "timerTask");
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().limitToProcessInstanceCompleted()).extracting(r -> Tuple.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getElementId(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"event_sub_task_timer", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"end_proc", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"event_sub_task_timer", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldTerminateEventSubprocessIfScopeTerminates() {
        BpmnModelInstance model = this.twoEventSubprocWithTasksModel(false, false, this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "123").create();
        this.triggerTimerStart(processInstanceKey);
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withType("timerTask").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().limitToProcessInstanceTerminated()).extracting(r -> Tuple.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldOnlyInterruptOnce() {
        BpmnModelInstance model = this.twoEventSubprocWithTasksModel(true, true, this.helper.getMessageName());
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("key", 123)).create();
        this.triggerTimerStart(processInstanceKey);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementId("event_sub_start_timer").await();
        this.triggerMessageStart(processInstanceKey, this.helper.getMessageName());
        ENGINE.job().ofInstance(processInstanceKey).withType("timerTask").complete();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.EVENT_SUB_PROCESS)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsExactly((Object[])new String[]{"event_sub_proc_timer"});
    }

    private void triggerMessageStart(long processInstanceKey, String msgName) {
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.message().withName(msgName).withCorrelationKey("123").publish();
    }

    private void triggerTimerStart(long processInstanceKey) {
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).await();
        ENGINE.increaseTime(Duration.ofSeconds(60L));
    }

    private static void completeJob(long processInstanceKey, String taskType) {
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withType(taskType).await();
        ENGINE.job().ofInstance(processInstanceKey).withType(taskType).complete();
    }

    private BpmnModelInstance twoEventSubprocModel(boolean timerInterrupt, boolean msgInterrupt, String msgName) {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID);
        ((StartEventBuilder)((StartEventBuilder)builder.eventSubProcess("event_sub_proc_timer").startEvent("event_sub_start_timer").interrupting(timerInterrupt)).timerWithDuration("PT60S")).endEvent("event_sub_end_timer");
        ((StartEventBuilder)((StartEventBuilder)builder.eventSubProcess("event_sub_proc_msg").startEvent("event_sub_start_msg").interrupting(msgInterrupt)).message(b -> b.name(msgName).zeebeCorrelationKeyExpression("key"))).endEvent("event_sub_end_msg");
        return builder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType("type")).endEvent("end_proc").done();
    }

    private BpmnModelInstance twoEventSubprocWithTasksModel(boolean timerInterrupt, boolean msgInterrupt, String msgName) {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID);
        ((StartEventBuilder)((StartEventBuilder)builder.eventSubProcess("event_sub_proc_timer").startEvent("event_sub_start_timer").interrupting(timerInterrupt)).timerWithDuration("PT60S")).serviceTask("event_sub_task_timer", b -> b.zeebeJobType("timerTask")).endEvent("event_sub_end_timer");
        ((StartEventBuilder)((StartEventBuilder)builder.eventSubProcess("event_sub_proc_msg").startEvent("event_sub_start_msg").interrupting(msgInterrupt)).message(b -> b.name(msgName).zeebeCorrelationKeyExpression("key"))).endEvent("event_sub_end_msg");
        return builder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType("type")).endEvent("end_proc").done();
    }

    private static BpmnModelInstance nestedMsgModel(String msgName) {
        StartEventBuilder procBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("proc_start");
        procBuilder.serviceTask("proc_task", b -> b.zeebeJobType("proc_type")).endEvent();
        EmbeddedSubProcessBuilder subProcBuilder = procBuilder.subProcess("sub_proc").embeddedSubProcess();
        ((StartEventBuilder)((StartEventBuilder)subProcBuilder.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(true)).message(b -> b.name(msgName).zeebeCorrelationKeyExpression("key"))).endEvent("event_sub_end");
        return subProcBuilder.startEvent("sub_start").serviceTask("sub_proc_task", t -> t.zeebeJobType("sub_proc_type")).endEvent("sub_end").done();
    }
}

