/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class MultiPartitionDeploymentLifecycleTest {
    public static final String PROCESS_ID = "process";
    public static final int PARTITION_ID = 1;
    public static final int PARTITION_COUNT = 3;
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.multiplePartition(3);
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldTestLifecycle() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldReDistributeAfterRecovery").startEvent().endEvent().done();
        ENGINE.deployment().withXmlResource("process.bpmn", modelInstance).deploy();
        List deploymentPartitionRecords = (List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(1)).limit(14L)).collect(Collectors.toList());
        Assertions.assertThat((List)deploymentPartitionRecords).extracting(new Function[]{Record::getIntent, Record::getRecordType}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATE, RecordType.COMMAND}), Assertions.tuple((Object[])new Object[]{ProcessIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentDistributionIntent.DISTRIBUTING, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentDistributionIntent.DISTRIBUTING, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentDistributionIntent.COMPLETE, RecordType.COMMAND}), Assertions.tuple((Object[])new Object[]{DeploymentDistributionIntent.COMPLETE, RecordType.COMMAND}), Assertions.tuple((Object[])new Object[]{DeploymentDistributionIntent.COMPLETED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentDistributionIntent.COMPLETED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.FULLY_DISTRIBUTED, RecordType.EVENT})});
        Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(2)).limit(2L)).collect(Collectors.toList()))).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{DeploymentIntent.DISTRIBUTE, DeploymentIntent.DISTRIBUTED});
        Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(3)).limit(2L)).collect(Collectors.toList()))).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{DeploymentIntent.DISTRIBUTE, DeploymentIntent.DISTRIBUTED});
    }
}

