/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class MultiPartitionDeploymentRecoveryTest {
    public static final String PROCESS_ID = "process";
    public static final int PARTITION_ID = 1;
    public static final int PARTITION_COUNT = 3;
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.multiplePartition(3);
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldReDistributeAfterRecovery() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldReDistributeAfterRecovery").startEvent().endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", modelInstance).expectCreated().deploy();
        ENGINE.stop();
        RecordingExporter.reset();
        ENGINE.start();
        Record fullyDistributedDeployment = (Record)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withRecordKey(deployment.getKey())).withIntent((Intent)DeploymentIntent.FULLY_DISTRIBUTED)).getFirst();
        Assertions.assertThat((long)fullyDistributedDeployment.getKey()).isNotNegative();
        Assertions.assertThat((int)fullyDistributedDeployment.getPartitionId()).isEqualTo(1);
        Assertions.assertThat((Comparable)fullyDistributedDeployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)fullyDistributedDeployment.getIntent()).isEqualTo((Object)DeploymentIntent.FULLY_DISTRIBUTED);
        Assertions.assertThat((long)((RecordStream)((RecordStream)RecordingExporter.records().limit(record -> record.getIntent().equals(DeploymentIntent.FULLY_DISTRIBUTED))).withIntent((Intent)DeploymentDistributionIntent.DISTRIBUTING)).count()).isEqualTo(2L);
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.DISTRIBUTE)).limit(record -> record.getIntent().equals(DeploymentIntent.FULLY_DISTRIBUTED))).count()).isGreaterThanOrEqualTo(2L);
        Assertions.assertThat((long)((RecordStream)((RecordStream)RecordingExporter.records().limit(record -> record.getIntent().equals(DeploymentIntent.FULLY_DISTRIBUTED))).withIntent((Intent)DeploymentDistributionIntent.COMPLETE)).count()).isGreaterThanOrEqualTo(2L);
    }
}

