/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.EvaluationContext;
import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessMessageStartEventMessageNameValidator;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessMessageStartEventMessageNameValidatorTest {
    private static final String TEST_EXPRESSION = "expression";
    private static final BpmnModelInstance MODEL = ((StartEventBuilder)Bpmn.createProcess().startEvent().message("expression")).endEvent().done();
    private static final StartEvent START_EVENT = (StartEvent)MODEL.getModelElementsByType(StartEvent.class).iterator().next();
    @Mock
    ExpressionLanguage mockExpressionLanguage;
    @Mock
    Expression mockExpression;
    @Mock
    EvaluationResult mockResult;
    @Mock
    ValidationResultCollector mockResultCollector;
    ProcessMessageStartEventMessageNameValidator sutValidator;

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockExpressionLanguage.parseExpression(TEST_EXPRESSION)).thenReturn((Object)this.mockExpression);
        Mockito.when((Object)this.mockExpressionLanguage.evaluateExpression((Expression)Mockito.eq((Object)this.mockExpression), (EvaluationContext)Mockito.any())).thenReturn((Object)this.mockResult);
        this.sutValidator = new ProcessMessageStartEventMessageNameValidator(this.mockExpressionLanguage);
    }

    @Test
    public void shouldLetValidMessageNameExpressionsPass() {
        Mockito.when((Object)this.mockResult.isFailure()).thenReturn((Object)false);
        Mockito.when((Object)this.mockResult.getType()).thenReturn((Object)ResultType.STRING);
        this.sutValidator.validate(START_EVENT, this.mockResultCollector);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockResultCollector});
    }

    @Test
    public void shoulAddErrorIfEvaluationFailed() {
        Mockito.when((Object)this.mockResult.isFailure()).thenReturn((Object)true);
        Mockito.when((Object)this.mockResult.getFailureMessage()).thenReturn((Object)"Test failure message");
        this.sutValidator.validate(START_EVENT, this.mockResultCollector);
        ((ValidationResultCollector)Mockito.verify((Object)this.mockResultCollector)).addError(0, "Expected constant expression but found 'expression', which could not be evaluated without context: Test failure message");
    }

    @Test
    public void shoulAddErrorIfEvaluationDoesNotReturnString() {
        Mockito.when((Object)this.mockResult.isFailure()).thenReturn((Object)false);
        Mockito.when((Object)this.mockResult.getType()).thenReturn((Object)ResultType.NUMBER);
        this.sutValidator.validate(START_EVENT, this.mockResultCollector);
        ((ValidationResultCollector)Mockito.verify((Object)this.mockResultCollector)).addError(0, "Expected constant expression of type String for message name 'expression', but was NUMBER");
    }
}

