/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.DeploymentClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

@RunWith(value=Parameterized.class)
public final class SuccessfulDeploymentTest {
    private static final VerificationWithTimeout VERIFICATION_TIMEOUT = Mockito.timeout((long)Duration.ofSeconds(10L).toMillis());
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public Function<DeploymentClient, Record<DeploymentRecordValue>> performDeployment;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"orphan error definition", SuccessfulDeploymentTest.deploy("/processes/orphan-error-definition.bpmn")}, {"none start event", SuccessfulDeploymentTest.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done())}, {"timer start event", SuccessfulDeploymentTest.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithCycle("R/PT10S")).endEvent().done())}, {"message start event", SuccessfulDeploymentTest.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("start")).endEvent().done())});
    }

    @Test
    public void shouldWriteDeploymentCreatedEvent() {
        Record<DeploymentRecordValue> deployment = this.performDeployment.apply(this.engine.deployment());
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata()).hasSize(1);
    }

    @Test
    public void shouldSendResponse() {
        Record<DeploymentRecordValue> deployment = this.performDeployment.apply(this.engine.deployment());
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter())).recordType(RecordType.EVENT);
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter())).valueType(ValueType.DEPLOYMENT);
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter())).intent((Intent)DeploymentIntent.CREATED);
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter())).key(deployment.getKey());
        ((CommandResponseWriter)Mockito.verify((Object)this.engine.getCommandResponseWriter(), (VerificationMode)VERIFICATION_TIMEOUT)).tryWriteResponse(Mockito.anyInt(), Mockito.anyLong());
    }

    private static Function<DeploymentClient, Record<DeploymentRecordValue>> deploy(String resource) {
        return deploymentClient -> deploymentClient.withXmlClasspathResource(resource).deploy();
    }

    private static Function<DeploymentClient, Record<DeploymentRecordValue>> deploy(BpmnModelInstance process) {
        return deploymentClient -> deploymentClient.withXmlResource(process).deploy();
    }
}

