/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessValidationUtil;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public final class TimerValidationTest {
    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"timerEvents"})
    @DisplayName(value="static timer expression with invalid cycle format")
    void invalidCycleFormat(String timerEventElementId, AbstractCatchEventBuilder<?, ?> timerEventBuilder) {
        BpmnModelInstance process = timerEventBuilder.timerWithCycle("foo").done();
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(timerEventElementId, "Invalid timer cycle expression (Repetition spec must start with R)"));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"timerEvents"})
    @DisplayName(value="static timer expression with invalid duration format")
    void invalidDurationFormat(String timerEventElementId, AbstractCatchEventBuilder<?, ?> timerEventBuilder) {
        BpmnModelInstance process = timerEventBuilder.timerWithDuration("foo").done();
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(timerEventElementId, "Invalid timer duration expression (Invalid duration format 'foo' for expression 'foo')"));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"timerEvents"})
    @DisplayName(value="static timer expression with invalid date format")
    void invalidDateFormat(String timerEventElementId, AbstractCatchEventBuilder<?, ?> timerEventBuilder) {
        BpmnModelInstance process = timerEventBuilder.timerWithDate("foo").done();
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(timerEventElementId, "Invalid timer date expression (Invalid date-time format 'foo' for expression 'foo')"));
    }

    @ParameterizedTest(name="[{index}] {1}")
    @MethodSource(value={"timerStartEventsWithExpression"})
    @DisplayName(value="timer expression of start event with variable access")
    void invalidStartEventExpressionWithVariable(String eventType, String timerType, Function<String, BpmnModelInstance> timerEventWithExpressionBuilder) {
        BpmnModelInstance process = timerEventWithExpressionBuilder.apply("x");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(StartEvent.class, "Invalid timer " + timerType + " expression (failed to evaluate expression 'x': no variable found for name 'x')"));
    }

    @ParameterizedTest(name="[{index}] {0} with {1}")
    @MethodSource(value={"timerEventsWithExpression"})
    @DisplayName(value="timer expression is not parsable")
    void notParsableTimerExpression(String eventType, String timerType, Function<String, BpmnModelInstance> timerEventWithExpressionBuilder) {
        BpmnModelInstance process = timerEventWithExpressionBuilder.apply("!");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(TimerEventDefinition.class, "failed to parse expression '!'"));
    }

    private static Stream<Arguments> timerEvents() {
        return Stream.of(Arguments.of((Object[])new Object[]{"start-event", Bpmn.createExecutableProcess((String)"process").startEvent("start-event")}), Arguments.of((Object[])new Object[]{"boundary-event", Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).boundaryEvent("boundary-event")}), Arguments.of((Object[])new Object[]{"intermediate-catch-event", Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("intermediate-catch-event")}), Arguments.of((Object[])new Object[]{"event-sub-process", Bpmn.createExecutableProcess((String)"process").eventSubProcess("subprocess").startEvent("event-sub-process")}));
    }

    private static Stream<Arguments> timerStartEventsWithExpression() {
        return Stream.of(Arguments.of((Object[])new Object[]{"start event", "cycle", TimerValidationTest.processBuilder(expression -> ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithCycleExpression(expression)).done())}), Arguments.of((Object[])new Object[]{"start event", "date", TimerValidationTest.processBuilder(expression -> ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithDateExpression(expression)).done())}));
    }

    private static Stream<Arguments> timerEventsWithExpression() {
        Stream<Arguments> otherTimerEventsWithExpressions = Stream.of(Arguments.of((Object[])new Object[]{"boundary event", "duration", TimerValidationTest.processBuilder(expression -> ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).boundaryEvent("boundary-event").timerWithDurationExpression(expression)).done())}), Arguments.of((Object[])new Object[]{"boundary event", "cycle", TimerValidationTest.processBuilder(expression -> ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).boundaryEvent("boundary-event").timerWithCycleExpression(expression)).done())}), Arguments.of((Object[])new Object[]{"intermediate catch event", "duration", TimerValidationTest.processBuilder(expression -> ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("intermediate-catch-event").timerWithDurationExpression(expression)).done())}), Arguments.of((Object[])new Object[]{"event sub-process", "duration", TimerValidationTest.processBuilder(expression -> Bpmn.createExecutableProcess((String)"process").eventSubProcess("sub-process", subProcess -> ((StartEventBuilder)subProcess.startEvent().timerWithDurationExpression(expression)).endEvent()).startEvent().endEvent().done())}), Arguments.of((Object[])new Object[]{"event sub-process", "cycle", TimerValidationTest.processBuilder(expression -> Bpmn.createExecutableProcess((String)"process").eventSubProcess("sub-process", subProcess -> ((StartEventBuilder)subProcess.startEvent().timerWithCycleExpression(expression)).endEvent()).startEvent().endEvent().done())}));
        return Stream.concat(TimerValidationTest.timerStartEventsWithExpression(), otherTimerEventsWithExpressions);
    }

    private static Function<String, BpmnModelInstance> processBuilder(Function<String, BpmnModelInstance> builder) {
        return builder;
    }
}

