/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.AbstractGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ConditionIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        ENGINE.deployment().withXmlResource(((AbstractGatewayBuilder)((AbstractGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("foo < 5")).endEvent().moveToLastGateway().sequenceFlowId("s2")).conditionExpression("foo > 10")).endEvent().done()).deploy();
    }

    @Test
    public void shouldCreateIncidentIfExclusiveGatewayHasNoMatchingCondition() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("foo", 9).create();
        Record failingEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.EXCLUSIVE_GATEWAY).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.CONDITION_ERROR)).hasErrorMessage("Expected at least one condition to evaluate to true, or to have a default flow")).hasBpmnProcessId(((ProcessInstanceRecordValue)failingEvent.getValue()).getBpmnProcessId())).hasProcessInstanceKey(((ProcessInstanceRecordValue)failingEvent.getValue()).getProcessInstanceKey())).hasElementId(((ProcessInstanceRecordValue)failingEvent.getValue()).getElementId())).hasElementInstanceKey(failingEvent.getKey())).hasVariableScopeKey(failingEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentIfConditionFailsToEvaluate() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("foo", "bar").create();
        Record failingEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.EXCLUSIVE_GATEWAY).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("failed to evaluate expression 'foo > 10': ValString(bar) can not be compared to ValNumber(10)")).hasBpmnProcessId(((ProcessInstanceRecordValue)failingEvent.getValue()).getBpmnProcessId())).hasProcessInstanceKey(((ProcessInstanceRecordValue)failingEvent.getValue()).getProcessInstanceKey())).hasElementId(((ProcessInstanceRecordValue)failingEvent.getValue()).getElementId())).hasElementInstanceKey(failingEvent.getKey())).hasVariableScopeKey(failingEvent.getKey());
    }

    @Test
    public void shouldResolveIncidentForFailedCondition() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("foo", "bar").create();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentEvent.getValue()).getVariableScopeKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"foo", (Object)11)})).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withRecordKey(((IncidentRecordValue)incidentEvent.getValue()).getElementInstanceKey())).limit(2L)).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATED});
        ((AbstractListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().onlyEvents()).limitToProcessInstance(processInstanceKey).incidentRecords()).extracting(Record::getIntent).hasSize(2)).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
    }

    @Test
    public void shouldResolveIncidentForExclusiveGatewayWithoutMatchingCondition() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("foo", 7).create();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentEvent.getValue()).getVariableScopeKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"foo", (Object)11)})).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withRecordKey(((IncidentRecordValue)incidentEvent.getValue()).getElementInstanceKey())).limit(2L)).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATED});
        ((AbstractListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().onlyEvents()).limitToProcessInstance(processInstanceKey).incidentRecords()).extracting(Record::getIntent).hasSize(2)).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
    }
}

