/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EventSubProcessIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "proc";
    private static final String JOB_TYPE = "type";
    private static String messageName;
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    @Parameterized.Parameter
    public String testName;
    @Parameterized.Parameter(value=1)
    public Function<StartEventBuilder, StartEventBuilder> builder;
    @Parameterized.Parameter(value=2)
    public Consumer<Long> triggerEventSubprocess;
    private ProcessMetadataValue currentProcess;

    @Parameterized.Parameters(name="{0} event subprocess")
    public static Object[][] parameters() {
        return new Object[][]{{"timer", EventSubProcessIncidentTest.eventSubprocess(s -> (StartEventBuilder)s.timerWithDuration("PT60S")), EventSubProcessIncidentTest.eventTrigger(key -> {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(key.longValue()).exists()).describedAs("Expected timer to exist", new Object[0])).isTrue();
            ENGINE.increaseTime(Duration.ofSeconds(60L));
        })}, {"message", EventSubProcessIncidentTest.eventSubprocess(s -> (StartEventBuilder)s.message(b -> b.name(messageName).zeebeCorrelationKeyExpression("key"))), EventSubProcessIncidentTest.eventTrigger(key -> {
            RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(key.longValue()).withMessageName(messageName).await();
            ENGINE.message().withName(messageName).withCorrelationKey("123").publish();
        })}, {"error", EventSubProcessIncidentTest.eventSubprocess(s -> (StartEventBuilder)s.error("ERROR")), EventSubProcessIncidentTest.eventTrigger(key -> ENGINE.job().ofInstance((long)key).withType(JOB_TYPE).withErrorCode("ERROR").throwError())}};
    }

    private static Function<StartEventBuilder, StartEventBuilder> eventSubprocess(Function<StartEventBuilder, StartEventBuilder> consumer) {
        return consumer;
    }

    private static Consumer<Long> eventTrigger(Consumer<Long> eventTrigger) {
        return eventTrigger;
    }

    @Before
    public void init() {
        messageName = this.helper.getMessageName();
    }

    @Test
    public void shouldCreateIncidentForInputMappingFailure() {
        BpmnModelInstance model = EventSubProcessIncidentTest.process(EventSubProcessIncidentTest.withEventSubprocessAndInputMapping(this.builder));
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("event_sub_start").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        IncidentRecordValue incidentEventValue = (IncidentRecordValue)incidentEvent.getValue();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)incidentEventValue).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId(PROCESS_ID)).hasProcessDefinitionKey(this.currentProcess.getProcessDefinitionKey())).hasProcessInstanceKey(processInstanceKey)).hasElementId("event_sub_start")).hasElementInstanceKey(failureEvent.getKey())).hasVariableScopeKey(((ProcessInstanceRecordValue)failureEvent.getValue()).getFlowScopeKey());
        Assertions.assertThat((String)incidentEventValue.getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'source'"});
    }

    @Test
    public void shouldResolveIncidentForInputMappingFailure() {
        BpmnModelInstance model = EventSubProcessIncidentTest.process(EventSubProcessIncidentTest.withEventSubprocessAndInputMapping(this.builder));
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        Record incidentEvent = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentEvent.getValue()).getVariableScopeKey()).withDocument(Map.of("source", "null")).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("event_sub_start").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(processInstanceKey).await();
    }

    @Test
    public void shouldRecreateIncidentOnResolveIncidentWithoutUpdateVariables() {
        BpmnModelInstance model = EventSubProcessIncidentTest.process(EventSubProcessIncidentTest.withEventSubprocessAndInputMapping(this.builder));
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        Record incidentEvent = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        long incidentCount = ((IncidentRecordStream)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).limit(2L)).count();
        Assertions.assertThat((long)incidentCount).isEqualTo(2L);
    }

    private long createInstanceAndTriggerEvent(BpmnModelInstance model) {
        long wfInstanceKey = this.createInstanceAndWaitForTask(model);
        this.triggerEventSubprocess.accept(wfInstanceKey);
        return wfInstanceKey;
    }

    private long createInstanceAndWaitForTask(BpmnModelInstance model) {
        this.currentProcess = (ProcessMetadataValue)((DeploymentRecordValue)ENGINE.deployment().withXmlResource(model).deploy().getValue()).getProcessesMetadata().get(0);
        long wfInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("key", 123)).create();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(wfInstanceKey).exists()).describedAs("Expected job to be created", new Object[0])).isTrue();
        return wfInstanceKey;
    }

    private static BpmnModelInstance process(ProcessBuilder processBuilder) {
        return processBuilder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent("end_proc").done();
    }

    private static ProcessBuilder withEventSubprocessAndInputMapping(Function<StartEventBuilder, StartEventBuilder> builder) {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)PROCESS_ID);
        builder.apply((StartEventBuilder)((EventSubProcessBuilder)process.eventSubProcess("event_sub_proc").zeebeInputExpression("=source", "localScope")).startEvent("event_sub_start").interrupting(true)).endEvent("event_sub_end");
        return process;
    }
}

