/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.JobClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobBatchRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class JobFailIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String JOB_TYPE = "test";
    private static final BpmnModelInstance PROCESS_INPUT_MAPPING = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("failingTask", t -> ((ServiceTaskBuilder)t.zeebeJobType(JOB_TYPE)).zeebeInputExpression("foo", "foo")).done();
    private static final Map<String, Object> VARIABLES = Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    private static long processDefinitionKey;
    @Rule
    public RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private long processInstanceKey;

    @BeforeClass
    public static void init() {
        processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    @Before
    public void beforeTest() {
        this.processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariables(VARIABLES).create();
        ((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(this.processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
        ENGINE.jobs().withType(JOB_TYPE).withMaxJobsToActivate(1).activate();
    }

    @Test
    public void shouldCreateIncidentWithANewKey() {
        Record<JobRecordValue> failedEvent = ENGINE.job().withType(JOB_TYPE).ofInstance(this.processInstanceKey).withRetries(0).fail();
        Record firstIncident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withJobKey(failedEvent.getKey()).getFirst();
        ENGINE.incident().ofInstance(this.processInstanceKey).withKey(firstIncident.getKey()).resolve();
        ENGINE.job().withType(JOB_TYPE).ofInstance(this.processInstanceKey).withRetries(0).fail();
        Record nextIncident = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).filter(r -> r.getPosition() > firstIncident.getPosition())).withJobKey(failedEvent.getKey()).getFirst();
        Assertions.assertThat((long)nextIncident.getKey()).isGreaterThan(firstIncident.getKey());
    }

    @Test
    public void shouldCreateIncidentIfJobHasNoRetriesLeft() {
        Record<JobRecordValue> failedEvent = ENGINE.job().withType(JOB_TYPE).ofInstance(this.processInstanceKey).fail();
        Record activityEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Assertions.assertThat((long)incidentEvent.getKey()).isGreaterThan(0L);
        Assertions.assertThat((long)incidentEvent.getSourceRecordPosition()).isEqualTo(failedEvent.getSourceRecordPosition());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.JOB_NO_RETRIES)).hasErrorMessage("No more retries left.")).hasBpmnProcessId("process")).hasProcessDefinitionKey(processDefinitionKey)).hasProcessInstanceKey(this.processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(activityEvent.getKey())).hasVariableScopeKey(activityEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentWithJobErrorMessage() {
        ENGINE.job().ofInstance(this.processInstanceKey).withType(JOB_TYPE).withErrorMessage("failed job").fail();
        Record activityEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Record failEvent = (Record)((JobRecordStream)RecordingExporter.jobRecords().withIntent((Intent)JobIntent.FAILED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(this.processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        Assertions.assertThat((long)incidentEvent.getKey()).isGreaterThan(0L);
        Assertions.assertThat((long)incidentEvent.getSourceRecordPosition()).isEqualTo(failEvent.getSourceRecordPosition());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.JOB_NO_RETRIES)).hasErrorMessage("failed job")).hasBpmnProcessId("process")).hasProcessDefinitionKey(processDefinitionKey)).hasProcessInstanceKey(this.processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(activityEvent.getKey())).hasVariableScopeKey(activityEvent.getKey());
    }

    @Test
    public void shouldIncidentContainLastFailedJobErrorMessage() {
        JobClient jobClient = ENGINE.job().ofInstance(this.processInstanceKey).withType(JOB_TYPE);
        jobClient.withRetries(1).withErrorMessage("first message").fail();
        ENGINE.jobs().withType(JOB_TYPE).activate();
        jobClient.withRetries(0).withErrorMessage("second message").fail();
        Record activityEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.JOB_NO_RETRIES)).hasErrorMessage("second message")).hasBpmnProcessId("process")).hasProcessDefinitionKey(processDefinitionKey)).hasProcessInstanceKey(this.processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(activityEvent.getKey())).hasVariableScopeKey(activityEvent.getKey());
    }

    @Test
    public void shouldResolveIncidentIfJobRetriesIncreased() {
        ENGINE.job().withType(JOB_TYPE).ofInstance(this.processInstanceKey).fail();
        Record incidentCreatedEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(this.processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.job().ofInstance(this.processInstanceKey).withType(JOB_TYPE).withRetries(1).updateRetries();
        Record<IncidentRecordValue> resolvedIncident = ENGINE.incident().ofInstance(this.processInstanceKey).withKey(incidentCreatedEvent.getKey()).resolve();
        ENGINE.jobs().withType(JOB_TYPE).activate();
        Record jobEvent = (Record)((JobRecordStream)RecordingExporter.jobRecords().withIntent((Intent)JobIntent.FAILED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Record activityEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.RESOLVE)).withRecordKey(incidentCreatedEvent.getKey())).getFirst();
        long lastPos = incidentEvent.getPosition();
        Assertions.assertThat((long)resolvedIncident.getKey()).isGreaterThan(0L);
        Assertions.assertThat((long)resolvedIncident.getSourceRecordPosition()).isEqualTo(lastPos);
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)resolvedIncident.getValue())).hasErrorType(ErrorType.JOB_NO_RETRIES)).hasErrorMessage("No more retries left.")).hasBpmnProcessId("process")).hasProcessDefinitionKey(processDefinitionKey)).hasProcessInstanceKey(this.processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(activityEvent.getKey())).hasVariableScopeKey(activityEvent.getKey());
        List batchActivations = (List)((JobBatchRecordStream)((JobBatchRecordStream)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATED).filter(jobBatchRecordValueRecord -> ((JobBatchRecordValue)jobBatchRecordValueRecord.getValue()).getJobs().stream().anyMatch(jobRecordValue -> jobRecordValue.getProcessInstanceKey() == this.processInstanceKey))).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((List)batchActivations).hasSize(2);
        JobRecordValue secondActivationJobValue = (JobRecordValue)((JobBatchRecordValue)((Record)batchActivations.get(1)).getValue()).getJobs().get(0);
        Long secondActivationJobKey = (Long)((JobBatchRecordValue)((Record)batchActivations.get(1)).getValue()).getJobKeys().get(0);
        Assertions.assertThat((Long)secondActivationJobKey).isEqualTo(jobEvent.getKey());
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)secondActivationJobValue).hasRetries(1);
        List jobEvents = (List)((JobRecordStream)((JobRecordStream)RecordingExporter.jobRecords().filter(r -> r.getKey() == jobEvent.getKey() || ((JobRecordValue)r.getValue()).getProcessInstanceKey() == this.processInstanceKey)).limit(5L)).collect(Collectors.toList());
        Assertions.assertThat((List)jobEvents).extracting(new Function[]{Record::getRecordType, Record::getValueType, Record::getIntent}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB, JobIntent.CREATED}), Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ValueType.JOB, JobIntent.FAIL}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB, JobIntent.FAILED}), Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ValueType.JOB, JobIntent.UPDATE_RETRIES}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB, JobIntent.RETRIES_UPDATED})});
    }

    @Test
    public void shouldDeleteIncidentIfJobIsCanceled() {
        ENGINE.job().withType(JOB_TYPE).ofInstance(this.processInstanceKey).fail();
        Record incidentCreatedEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(this.processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(this.processInstanceKey).cancel();
        Record terminateTaskCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.TERMINATE_ELEMENT)).getFirst();
        Record jobCancelCommand = (Record)((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(this.processInstanceKey).withIntent((Intent)JobIntent.CANCEL)).getFirst();
        Record resolvedIncidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(this.processInstanceKey).withIntent((Intent)IncidentIntent.RESOLVED)).getFirst();
        Assertions.assertThat((long)resolvedIncidentEvent.getKey()).isEqualTo(incidentCreatedEvent.getKey());
        Assertions.assertThat((long)resolvedIncidentEvent.getSourceRecordPosition()).isEqualTo(terminateTaskCommand.getPosition());
        Assertions.assertThat((long)jobCancelCommand.getSourceRecordPosition()).isEqualTo(terminateTaskCommand.getPosition());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)resolvedIncidentEvent.getValue())).hasErrorType(ErrorType.JOB_NO_RETRIES)).hasErrorMessage("No more retries left.")).hasBpmnProcessId("process")).hasProcessDefinitionKey(processDefinitionKey)).hasProcessInstanceKey(this.processInstanceKey)).hasElementId("failingTask")).hasVariableScopeKey(terminateTaskCommand.getKey());
    }
}

