/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class MappingIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final BpmnModelInstance PROCESS_INPUT_MAPPING = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("failingTask", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).zeebeInputExpression("foo", "foo")).done();
    private static final BpmnModelInstance PROCESS_OUTPUT_MAPPING = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("failingTask", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).zeebeOutputExpression("foo", "foo")).done();
    private static final Map<String, Object> VARIABLES = Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    private static final String VARIABLES_JSON = "{'string':'value', 'jsonObject':{'testAttr':'test'}}";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCreateIncidentForInputMappingFailure() {
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record failureCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)incidentEvent.getKey()).isGreaterThan(0L);
        Assertions.assertThat((long)incidentEvent.getSourceRecordPosition()).isEqualTo(failureCommand.getPosition());
        Assertions.assertThat((long)((IncidentRecordValue)incidentEvent.getValue()).getVariableScopeKey()).isEqualTo(failureCommand.getKey());
        IncidentRecordValue incidentEventValue = (IncidentRecordValue)incidentEvent.getValue();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)incidentEventValue).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessDefinitionKey(processDefinitionKey)).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(failureCommand.getKey())).hasVariableScopeKey(failureCommand.getKey());
        Assertions.assertThat((String)incidentEventValue.getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
    }

    @Test
    public void shouldCreateIncidentForNonMatchingAndMatchingValueOnInputMapping() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("service", t -> ((ServiceTaskBuilder)((ServiceTaskBuilder)t.zeebeJobType("external")).zeebeInputExpression("notExisting", "nullVal")).zeebeInputExpression("string", "existing")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariables(VARIABLES_JSON).create();
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("service").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        Assertions.assertThat((long)incidentEvent.getKey()).isGreaterThan(0L);
        Assertions.assertThat((long)((IncidentRecordValue)incidentEvent.getValue()).getVariableScopeKey()).isEqualTo(failureEvent.getKey());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("service")).hasElementInstanceKey(failureEvent.getKey())).hasVariableScopeKey(failureEvent.getKey());
        Assertions.assertThat((String)((IncidentRecordValue)incidentEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'notExisting'"});
    }

    @Test
    public void shouldResolveIncidentForInputMappingFailure() {
        ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((ProcessInstanceRecordValue)failureEvent.getValue()).getFlowScopeKey()).withDocument(VARIABLES).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        Record followUpEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentResolveCommand = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.RESOLVE)).withRecordKey(incidentEvent.getKey())).getFirst();
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentEvent.getKey());
        Assertions.assertThat((long)incidentResolveCommand.getPosition()).isEqualTo(followUpEvent.getSourceRecordPosition());
        Assertions.assertThat((long)incidentResolveCommand.getPosition()).isEqualTo(incidentResolvedEvent.getSourceRecordPosition());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentResolvedEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(failureEvent.getKey())).hasVariableScopeKey(failureEvent.getKey());
        Assertions.assertThat((String)((IncidentRecordValue)incidentEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
    }

    @Test
    public void shouldResolveIncidentForOutputMappingFailure() {
        ENGINE.deployment().withXmlResource(PROCESS_OUTPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        ENGINE.job().ofInstance(processInstanceKey).withType("test").withVariables(VARIABLES_JSON).complete();
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.variables().ofScope(failureEvent.getKey()).withDocument(VARIABLES).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        Record followUpEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentResolveCommand = (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.RESOLVE)).withRecordKey(incidentEvent.getKey())).getFirst();
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentEvent.getKey());
        Assertions.assertThat((long)incidentResolveCommand.getPosition()).isEqualTo(followUpEvent.getSourceRecordPosition());
        Assertions.assertThat((long)incidentResolveCommand.getPosition()).isEqualTo(incidentResolvedEvent.getSourceRecordPosition());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentResolvedEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(failureEvent.getKey())).hasVariableScopeKey(failureEvent.getKey());
        Assertions.assertThat((String)((IncidentRecordValue)incidentResolvedEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
    }

    @Test
    public void shouldCreateNewIncidentAfterResolvedFirstOne() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("failingTask", t -> ((ServiceTaskBuilder)((ServiceTaskBuilder)t.zeebeJobType("external")).zeebeInputExpression("foo", "foo")).zeebeInputExpression("bar", "bar")).done();
        ENGINE.deployment().withXmlResource(modelInstance).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        Assertions.assertThat((String)((IncidentRecordValue)incidentEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
        ENGINE.variables().ofScope(failureEvent.getKey()).withDocument(VARIABLES).update();
        Record<IncidentRecordValue> resolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentEvent.getKey()).resolve();
        Assertions.assertThat((long)resolvedEvent.getKey()).isEqualTo(incidentEvent.getKey());
        Record secondIncidentEvent = (Record)((IncidentRecordStream)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(e -> e.getIntent() == IncidentIntent.RESOLVED)).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)secondIncidentEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(failureEvent.getKey())).hasVariableScopeKey(failureEvent.getKey());
        Assertions.assertThat((String)((IncidentRecordValue)secondIncidentEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'bar'"});
    }

    @Test
    public void shouldResolveIncidentAfterPreviousResolvingFailed() {
        ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record firstIncident = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.variables().ofScope(failureEvent.getKey()).withDocument(new HashMap<String, Object>()).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(firstIncident.getKey()).resolve();
        Record secondIncident = (Record)((IncidentRecordStream)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(e -> e.getIntent() == IncidentIntent.RESOLVED)).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.variables().ofScope(failureEvent.getKey()).withDocument(VARIABLES).update();
        Record<IncidentRecordValue> secondResolvedIncident = ENGINE.incident().ofInstance(processInstanceKey).withKey(secondIncident.getKey()).resolve();
        Assertions.assertThat((long)secondResolvedIncident.getKey()).isGreaterThan(firstIncident.getKey());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)secondResolvedIncident.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(failureEvent.getKey())).hasVariableScopeKey(failureEvent.getKey());
        Assertions.assertThat((String)((IncidentRecordValue)secondResolvedIncident.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
    }

    @Test
    public void shouldResolveMultipleIncidents() {
        ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(failureEvent.getKey()).withDocument(VARIABLES).update();
        ENGINE.incident().ofInstance(processInstanceKey).resolve();
        processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        failureEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(processInstanceKey).getFirst();
        long secondIncidentKey = ((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        ENGINE.variables().ofScope(failureEvent.getKey()).withDocument(VARIABLES).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).resolve();
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(secondIncidentKey);
    }

    @Test
    public void shouldResolveIncidentIfActivityTerminated() {
        ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record incidentCreatedEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record terminateActivity = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("failingTask").withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.TERMINATE_ELEMENT)).getFirst();
        Record incidentResolvedEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.RESOLVED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedEvent.getKey());
        Assertions.assertThat((long)terminateActivity.getPosition()).isEqualTo(incidentResolvedEvent.getSourceRecordPosition());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentResolvedEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(((IncidentRecordValue)incidentResolvedEvent.getValue()).getElementInstanceKey())).hasVariableScopeKey(((IncidentRecordValue)incidentResolvedEvent.getValue()).getElementInstanceKey());
        Assertions.assertThat((String)((IncidentRecordValue)incidentResolvedEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
    }

    @Test
    public void shouldProcessIncidentsAfterMultipleTerminations() {
        ENGINE.deployment().withXmlResource(PROCESS_INPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariables(VARIABLES_JSON).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record incidentCreatedEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.RESOLVED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)incidentEvent.getKey()).isEqualTo(incidentCreatedEvent.getKey());
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey)).hasElementId("failingTask")).hasElementInstanceKey(((IncidentRecordValue)incidentEvent.getValue()).getElementInstanceKey())).hasVariableScopeKey(((IncidentRecordValue)incidentEvent.getValue()).getElementInstanceKey());
        Assertions.assertThat((String)((IncidentRecordValue)incidentEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"no variable found for name 'foo'"});
    }
}

