/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class MessageIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("catch", e -> e.message(m -> m.name("cancel").zeebeCorrelationKeyExpression("orderId"))).done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        ENGINE.deployment().withXmlResource(PROCESS).deploy();
    }

    private BpmnModelInstance createProcessWithMessageNameFeelExpression(String processId) {
        return Bpmn.createExecutableProcess((String)processId).startEvent().intermediateCatchEvent("catch", e -> e.message(m -> m.nameExpression("nameLookup").zeebeCorrelationKeyExpression("12345"))).done();
    }

    @Test
    public void shouldCreateIncidentIfNameExpressionCannotBeEvaluated() {
        ENGINE.deployment().withXmlResource(this.createProcessWithMessageNameFeelExpression("UNRESOLVABLE_NAME_EXPRESSION")).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("UNRESOLVABLE_NAME_EXPRESSION").create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("catch").withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("failed to evaluate expression 'nameLookup': no variable found for name 'nameLookup'")).hasBpmnProcessId("UNRESOLVABLE_NAME_EXPRESSION")).hasProcessInstanceKey(processInstanceKey)).hasElementId("catch")).hasElementInstanceKey(failureEvent.getKey())).hasJobKey(-1L)).hasVariableScopeKey(failureEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentIfNameExpressionEvaluatesToWrongType() {
        ENGINE.deployment().withXmlResource(this.createProcessWithMessageNameFeelExpression("NAME_EXPRESSION_INVALID_TYPE")).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("NAME_EXPRESSION_INVALID_TYPE").withVariable("nameLookup", 25).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("catch").withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("Expected result of the expression 'nameLookup' to be 'STRING', but was 'NUMBER'.")).hasBpmnProcessId("NAME_EXPRESSION_INVALID_TYPE")).hasProcessInstanceKey(processInstanceKey)).hasElementId("catch")).hasElementInstanceKey(failureEvent.getKey())).hasJobKey(-1L)).hasVariableScopeKey(failureEvent.getKey());
    }

    @Test
    public void shouldResolveIncidentIfNameCouldNotBeEvaluated() {
        ENGINE.deployment().withXmlResource(this.createProcessWithMessageNameFeelExpression("UNRESOLVABLE_NAME_EXPRESSION2")).deploy();
        long processInstance = ENGINE.processInstance().ofBpmnProcessId("UNRESOLVABLE_NAME_EXPRESSION2").create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstance).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"nameLookup", (Object)"messageName")})).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstance).withKey(incidentCreatedRecord.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstance).exists()).isTrue();
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedRecord.getKey());
    }

    @Test
    public void shouldCreateIncidentIfCorrelationKeyNotFound() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("catch").withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("failed to evaluate expression 'orderId': no variable found for name 'orderId'")).hasBpmnProcessId(PROCESS_ID)).hasProcessInstanceKey(processInstanceKey)).hasElementId("catch")).hasElementInstanceKey(failureEvent.getKey())).hasJobKey(-1L)).hasVariableScopeKey(failureEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentIfCorrelationKeyOfInvalidType() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("orderId", true).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId("catch").getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("Failed to extract the correlation key for 'orderId': The value must be either a string or a number, but was BOOLEAN.")).hasBpmnProcessId(PROCESS_ID)).hasProcessInstanceKey(processInstanceKey)).hasElementId("catch")).hasElementInstanceKey(failureEvent.getKey())).hasJobKey(-1L)).hasVariableScopeKey(failureEvent.getKey());
    }

    @Test
    public void shouldResolveIncidentIfCorrelationKeyNotFound() {
        long processInstance = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstance).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"orderId", (Object)"order123")})).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstance).withKey(incidentCreatedRecord.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstance).exists()).isTrue();
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedRecord.getKey());
    }
}

