/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.engine.util.Records;
import io.camunda.zeebe.engine.util.client.IncidentClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class MultiInstanceIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String MULTI_TASK_PROCESS = "multi-task-process";
    private static final String MULTI_SUB_PROC_PROCESS = "multi-sub-process-process";
    private static final String ELEMENT_ID = "task";
    private static final String INPUT_COLLECTION = "items";
    private static final String INPUT_ELEMENT = "item";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private String jobType;

    @Before
    public void init() {
        this.jobType = this.helper.getJobType();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)MULTI_TASK_PROCESS).startEvent().serviceTask(ELEMENT_ID, t -> ((ServiceTaskBuilder)t.zeebeJobType(this.jobType)).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)b.zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT)).zeebeOutputElementExpression("{x: undefined_var}")).zeebeOutputCollection("results"))).endEvent().done()).deploy();
    }

    @Test
    public void shouldCreateIncidentIfInputVariableNotFound() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(MULTI_TASK_PROCESS).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(ELEMENT_ID).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incident.getValue())).hasElementInstanceKey(elementInstance.getKey())).hasElementId(((ProcessInstanceRecordValue)elementInstance.getValue()).getElementId())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("failed to evaluate expression 'items': no variable found for name 'items'");
    }

    @Test
    public void shouldCreateIncidentIfInputVariableIsNotAnArray() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(MULTI_TASK_PROCESS).withVariable(INPUT_COLLECTION, "not-an-array-but-a-string").create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(ELEMENT_ID).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incident.getValue())).hasElementInstanceKey(elementInstance.getKey())).hasElementId(((ProcessInstanceRecordValue)elementInstance.getValue()).getElementId())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("Expected result of the expression 'items' to be 'ARRAY', but was 'STRING'.");
    }

    @Test
    public void shouldCreateIncidentIfOutputElementExpressionEvaluationFailed() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(MULTI_TASK_PROCESS).withVariable(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).create();
        ENGINE.job().withType(this.jobType).ofInstance(processInstanceKey).complete();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record elementInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETING).withProcessInstanceKey(processInstanceKey).withElementId(ELEMENT_ID).getFirst();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incident.getValue())).hasElementInstanceKey(elementInstance.getKey())).hasElementId(((ProcessInstanceRecordValue)elementInstance.getValue()).getElementId())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR)).hasErrorMessage("failed to evaluate expression '{x: undefined_var}': no variable found for name 'undefined_var'");
    }

    @Test
    public void shouldCollectOutputResultsForResolvedIncidentOfOutputElementExpression() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(MULTI_TASK_PROCESS).withVariable(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).create();
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 1);
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"undefined_var", (Object)1)})).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 2);
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withElementType(BpmnElementType.PROCESS).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().exists()).describedAs("the process has completed", new Object[0])).isTrue();
        ((AbstractObjectAssert)Assertions.assertThat((Object)((Record)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withName("results").limit(4L)).getLast())).extracting(Record::getValue).extracting(VariableRecordValue::getValue).describedAs("the results have been collected", new Object[0])).isEqualTo((Object)"[{\"x\":1},{\"x\":1},{\"x\":1}]");
    }

    @Test
    public void shouldResolveIncident() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(MULTI_TASK_PROCESS).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incident.getValue()).getVariableScopeKey()).withDocument(Collections.singletonMap(INPUT_COLLECTION, Arrays.asList(10, 20, 30))).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withRecordKey(((IncidentRecordValue)incident.getValue()).getElementInstanceKey())).limit(3L)).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATED});
    }

    @Test
    public void shouldUseTheSameLoopVariablesWhenIncidentResolved() {
        ENGINE.deployment().withXmlResource(((SubProcessBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)MULTI_SUB_PROC_PROCESS).startEvent().subProcess("sub-process").zeebeInputExpression("y", "y")).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)b.parallel()).zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT))).embeddedSubProcess().startEvent("sub-process-start").endEvent("sub-process-end").moveToNode("sub-process").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(MULTI_SUB_PROC_PROCESS).withVariables("{\"items\":[1,2,3]}").create();
        List incidents = ((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(3L)).map(Record::getKey).collect(Collectors.toList());
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of("y", 1)).update();
        incidents.stream().map(key -> ENGINE.incident().ofInstance(processInstanceKey).withKey((long)key)).forEach(IncidentClient.ResolveIncidentClient::resolve);
        Set<String> variableNames = Set.of(INPUT_ELEMENT, "loopCounter");
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().filter(v -> variableNames.contains(((VariableRecordValue)v.getValue()).getName()))).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getIntent(), ((VariableRecordValue)v.getValue()).getName(), ((VariableRecordValue)v.getValue()).getValue()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, INPUT_ELEMENT, "1"}), Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, "loopCounter", "1"}), Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, INPUT_ELEMENT, "2"}), Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, "loopCounter", "2"}), Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, INPUT_ELEMENT, "3"}), Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, "loopCounter", "3"})});
    }

    @Test
    public void shouldResolveIncidentDueToInputCollection() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"multi-task").startEvent().serviceTask(ELEMENT_ID, t -> ((ServiceTaskBuilder)t.zeebeJobType(this.jobType)).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)b.sequential()).zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("multi-task").withVariable(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).create();
        Record activatedTask = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId(ELEMENT_ID).getFirst();
        ENGINE.variables().ofScope(activatedTask.getKey()).withDocument(Collections.singletonMap(INPUT_COLLECTION, "not a list")).update();
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 1);
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(activatedTask.getKey()).withDocument(Collections.singletonMap(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 2);
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 3);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).limitToProcessInstanceCompleted().await();
    }

    @Test
    public void shouldCreateIncidentWhenInputCollectionModifiedConcurrently() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"multi-task").startEvent().serviceTask(ELEMENT_ID, t -> t.zeebeJobType(this.jobType)).sequenceFlowId("from-task-to-multi-instance")).serviceTask("multi-instance", t -> t.zeebeJobType(this.jobType)).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)b.parallel()).zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("multi-task").withVariable(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).create();
        Record serviceTask = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        Record<JobRecordValue> job = MultiInstanceIncidentTest.findNthJob(processInstanceKey, 1);
        long nextKey = ENGINE.getZeebeState().getKeyGenerator().nextKey();
        ENGINE.stop();
        RecordingExporter.reset();
        ProcessInstanceRecord sequenceFlow = Records.processInstance(processInstanceKey, "multi-task").setBpmnElementType(BpmnElementType.SEQUENCE_FLOW).setElementId("from-task-to-multi-instance").setFlowScopeKey(processInstanceKey).setProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey());
        ProcessInstanceRecord multiInstanceBody = Records.processInstance(processInstanceKey, "multi-task").setBpmnElementType(BpmnElementType.MULTI_INSTANCE_BODY).setElementId("multi-instance").setFlowScopeKey(processInstanceKey).setProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey());
        ENGINE.writeRecords(RecordToWrite.command().key(job.getKey()).job(JobIntent.COMPLETE, (JobRecordValue)job.getValue()), RecordToWrite.event().causedBy(0).key(job.getKey()).job(JobIntent.COMPLETED, (JobRecordValue)job.getValue()), RecordToWrite.command().causedBy(0).key(serviceTask.getKey()).processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)serviceTask.getValue()), RecordToWrite.event().causedBy(2).key(serviceTask.getKey()).processInstance(ProcessInstanceIntent.ELEMENT_COMPLETING, (ProcessInstanceRecordValue)serviceTask.getValue()), RecordToWrite.event().causedBy(2).key(serviceTask.getKey()).processInstance(ProcessInstanceIntent.ELEMENT_COMPLETED, (ProcessInstanceRecordValue)serviceTask.getValue()), RecordToWrite.event().causedBy(2).key(nextKey).processInstance(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, (ProcessInstanceRecordValue)sequenceFlow), RecordToWrite.command().causedBy(2).processInstance(ProcessInstanceIntent.ACTIVATE_ELEMENT, (ProcessInstanceRecordValue)multiInstanceBody), RecordToWrite.command().variable(VariableDocumentIntent.UPDATE, (VariableDocumentRecordValue)Records.variableDocument(processInstanceKey, "{\"items\":0}")));
        ENGINE.start();
        List incidents = ((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(3L)).asList();
        ((ListAssert)Assertions.assertThat((List)incidents).describedAs("Should create incident for each child when input element cannot be retrieved from input collection", new Object[0])).extracting(Record::getValue).extracting(new Function[]{IncidentRecordValue::getElementId, IncidentRecordValue::getErrorType, IncidentRecordValue::getErrorMessage}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"multi-instance", ErrorType.EXTRACT_VALUE_ERROR, "Expected result of the expression 'items' to be 'ARRAY', but was 'NUMBER'."})});
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Collections.singletonMap(INPUT_COLLECTION, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))).update();
        incidents.forEach(i -> ENGINE.incident().ofInstance(processInstanceKey).withKey(i.getKey()).resolve());
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 2);
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 3);
        MultiInstanceIncidentTest.completeNthJob(processInstanceKey, 4);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
    }

    private static void completeNthJob(long processInstanceKey, int n) {
        Record<JobRecordValue> nthJob = MultiInstanceIncidentTest.findNthJob(processInstanceKey, n);
        ENGINE.job().withKey(nthJob.getKey()).complete();
    }

    private static Record<JobRecordValue> findNthJob(long processInstanceKey, int n) {
        return (Record)((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).skip((long)(n - 1))).getFirst();
    }
}

