/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class JobThrowErrorTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static String jobType;
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Before
    public void setup() {
        jobType = this.helper.getJobType();
    }

    @Test
    public void shouldThrowError() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").withErrorMessage("error-message").throwError();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRecordType(RecordType.EVENT)).hasIntent((Intent)JobIntent.ERROR_THROWN);
        ((JobRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)result.getValue())).hasErrorCode("error")).hasErrorMessage("error-message");
    }

    @Test
    public void shouldRejectIfJobNotFound() {
        int key = 123;
        Record<JobRecordValue> result = ENGINE.job().withKey(123L).withErrorCode("error").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectIfJobIsFailed() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        ENGINE.jobs().withType(jobType).activate();
        ENGINE.job().withKey(job.getKey()).withRetries(0).fail();
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)result.getRejectionReason()).contains(new CharSequence[]{"it is in state 'FAILED'"});
    }

    @Test
    public void shouldRejectIfErrorIsThrown() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        Record<JobRecordValue> result = ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)result.getRejectionReason()).contains(new CharSequence[]{"it is in state 'ERROR_THROWN'"});
    }
}

