/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.JobTimeoutTrigger;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.sched.ActorControl;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public final class JobTimeoutTriggerTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    @Mock
    private ActorControl someActor;
    @Mock
    private TypedStreamWriter typedStreamWriter;
    private JobTimeoutTrigger jobTimeoutTrigger;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        MutableJobState jobState = this.stateRule.getZeebeState().getJobState();
        this.jobTimeoutTrigger = new JobTimeoutTrigger((JobState)jobState);
        ProcessingContext processingContext = new ProcessingContext().actor(this.someActor).logStreamWriter(this.typedStreamWriter);
        processingContext.enableLogStreamWriter();
        this.jobTimeoutTrigger.onRecovered((ReadonlyProcessingContext)processingContext);
        jobState.activate(0L, this.newJobRecord());
        jobState.activate(1L, this.newJobRecord());
        jobState.activate(2L, this.newJobRecord());
    }

    private JobRecord newJobRecord() {
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(2);
        jobRecord.setDeadline(256L);
        jobRecord.setType("test");
        return jobRecord;
    }

    @Test
    public void shouldNotWriteAgainAfterFlushFailed() {
        Mockito.when((Object)this.typedStreamWriter.flush()).thenReturn((Object)1L, (Object[])new Long[]{-1L});
        this.jobTimeoutTrigger.deactivateTimedOutJobs();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.typedStreamWriter});
        ((TypedStreamWriter)inOrder.verify((Object)this.typedStreamWriter)).reset();
        ((TypedStreamWriter)inOrder.verify((Object)this.typedStreamWriter)).appendFollowUpCommand(ArgumentMatchers.eq((long)0L), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (RecordValue)ArgumentMatchers.any(JobRecord.class));
        ((TypedStreamWriter)inOrder.verify((Object)this.typedStreamWriter)).flush();
        ((TypedStreamWriter)inOrder.verify((Object)this.typedStreamWriter)).reset();
        ((TypedStreamWriter)inOrder.verify((Object)this.typedStreamWriter)).appendFollowUpCommand(ArgumentMatchers.eq((long)1L), (Intent)ArgumentMatchers.eq((Object)JobIntent.TIME_OUT), (RecordValue)ArgumentMatchers.any(JobRecord.class));
        ((TypedStreamWriter)inOrder.verify((Object)this.typedStreamWriter)).flush();
        inOrder.verifyNoMoreInteractions();
    }
}

