/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessInstanceTokenTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private String processId;

    @Before
    public void setUp() {
        this.processId = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldCompleteInstanceAfterEndEvent() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end");
    }

    @Test
    public void shouldCompleteInstanceAfterEventWithoutOutgoingSequenceFlows() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent("start").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "start");
    }

    @Test
    public void shouldCompleteInstanceAfterActivityWithoutOutgoingSequenceFlows() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().serviceTask("task", t -> t.zeebeJobType("task")).done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "task");
    }

    @Test
    public void shouldCompleteInstanceAfterParallelSplit() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task-1", t -> t.zeebeJobType("task-1")).endEvent("end-1").moveToLastGateway().serviceTask("task-2", t -> t.zeebeJobType("task-2")).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-2").complete();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldCompleteInstanceAfterParallelJoin() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway("fork").serviceTask("task-1", t -> t.zeebeJobType("task-1")).parallelGateway("join").endEvent("end").moveToNode("fork").serviceTask("task-2", t -> t.zeebeJobType("task-2")).connectTo("join").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-2").complete();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end");
    }

    @Test
    public void shouldCompleteInstanceAfterMessageIntermediateCatchEvent() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task", t -> t.zeebeJobType("task")).endEvent("end-1").moveToLastGateway().intermediateCatchEvent("catch", e -> e.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).withVariables("{'key':'123'}").create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ENGINE.message().withName("msg").withCorrelationKey("123").publish();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldCompleteInstanceAfterTimerIntermediateCatchEvent() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task", t -> t.zeebeJobType("task")).endEvent("end-1").moveToLastGateway().intermediateCatchEvent("catch", e -> e.timerWithDuration("PT0.1S")).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldCompleteInstanceAfterSubProcessEnded() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task-1", t -> t.zeebeJobType("task-1")).endEvent("end-1").moveToLastGateway().subProcess("sub", s -> s.embeddedSubProcess().startEvent().serviceTask("task-2", t -> t.zeebeJobType("task-2")).endEvent("end-sub")).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-2").complete();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldCompleteInstanceAfterEventBasedGateway() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task", t -> t.zeebeJobType("task")).endEvent("end-1").moveToLastGateway().eventBasedGateway("gateway").intermediateCatchEvent("catch-1", e -> e.message(m -> m.name("msg-1").zeebeCorrelationKeyExpression("key"))).endEvent("end-2").moveToNode("gateway").intermediateCatchEvent("catch-2", e -> e.message(m -> m.name("msg-2").zeebeCorrelationKeyExpression("key"))).endEvent("end-3").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).withVariables("{'key':'123'}").create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ENGINE.message().withName("msg-1").withCorrelationKey("123").publish();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldCompleteInstanceAfterInterruptingBoundaryEventTriggered() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent("end-1").moveToActivity("task").boundaryEvent("timeout", b -> ((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT0.1S")).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldCompleteInstanceAfterNonInterruptingBoundaryEventTriggered() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().serviceTask("task-1", t -> t.zeebeJobType("task-1")).endEvent("end-1").moveToActivity("task-1").boundaryEvent("timeout", b -> ((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(false))).timerWithCycle("R1/PT0.1S")).serviceTask("task-2", t -> t.zeebeJobType("task-2")).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        ENGINE.job().ofInstance(processInstanceKey).withType("task-2").complete();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-1");
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldNotCompleteInstanceAfterIncidentIsRaisedOnEvent() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task", t -> t.zeebeJobType("task")).endEvent("end-1").moveToLastGateway().intermediateCatchEvent("catch", e -> e.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ENGINE.variables().ofScope(((IncidentRecordValue)incident.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"key", (Object)"123")})).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        ENGINE.message().withName("msg").withCorrelationKey("123").publish();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldNotCompleteInstanceAfterIncidentIsRaisedOnActivity() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task-1", t -> t.zeebeJobType("task-1")).endEvent("end-1").moveToLastGateway().serviceTask("task-2", t -> ((ServiceTaskBuilder)t.zeebeJobType("task-2")).zeebeOutputExpression("result", "r")).endEvent("end-2").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-2").complete();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        ENGINE.variables().ofScope(((IncidentRecordValue)incident.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"result", (Object)"123")})).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    @Test
    public void shouldNotCompleteInstanceAfterIncidentIsRaisedOnExclusiveGateway() {
        ENGINE.deployment().withXmlResource(((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().parallelGateway().serviceTask("task", t -> t.zeebeJobType("task")).endEvent("end-1").moveToLastGateway().exclusiveGateway("gateway").defaultFlow()).endEvent("end-2").moveToNode("gateway").sequenceFlowId("to-end-3").conditionExpression("x < 21").endEvent("end-3").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ENGINE.variables().ofScope(((IncidentRecordValue)incident.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)123)})).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        this.assertThatProcessInstanceCompletedAfter(processInstanceKey, "end-2");
    }

    private void assertThatProcessInstanceCompletedAfter(long processInstanceKey, String elementId) {
        Record lastEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId(elementId).getFirst();
        Record completedEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId(this.processId).getFirst();
        Assertions.assertThat((long)completedEvent.getPosition()).isGreaterThan(lastEvent.getPosition());
    }
}

