/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.processing.streamprocessor.FailedPropertyBasedTestDataPrinter;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.ProcessExecutor;
import io.camunda.zeebe.engine.util.client.DeploymentClient;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPath;
import io.camunda.zeebe.test.util.bpmn.random.ScheduledExecutionStep;
import io.camunda.zeebe.test.util.bpmn.random.TestDataGenerator;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Collection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProcessExecutionRandomizedPropertyTest {
    private static final String PROCESS_COUNT = System.getProperty("processCount", "3");
    private static final String EXECUTION_PATH_COUNT = System.getProperty("executionCount", "30");
    @Rule
    public final EngineRule engineRule = EngineRule.singlePartition();
    @Parameterized.Parameter
    public TestDataGenerator.TestDataRecord record;
    @Rule
    public TestWatcher failedTestDataPrinter = new FailedPropertyBasedTestDataPrinter(this::getDataRecord);
    private final ProcessExecutor processExecutor = new ProcessExecutor(this.engineRule);

    public TestDataGenerator.TestDataRecord getDataRecord() {
        return this.record;
    }

    @Test
    public void shouldExecuteProcessToEnd() {
        DeploymentClient deployment = this.engineRule.deployment();
        this.record.getBpmnModels().forEach(deployment::withXmlResource);
        deployment.deploy();
        ExecutionPath path = this.record.getExecutionPath();
        path.getSteps().stream().peek(scheduledExecutionStep -> this.record.setCurrentStep(scheduledExecutionStep)).map(ScheduledExecutionStep::getStep).forEach(this.processExecutor::applyStep);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withElementType(BpmnElementType.PROCESS).withBpmnProcessId(path.getProcessId()).await();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestDataGenerator.TestDataRecord> getTestRecords() {
        return TestDataGenerator.generateTestRecords((int)Integer.parseInt(PROCESS_COUNT), (int)Integer.parseInt(EXECUTION_PATH_COUNT));
    }
}

