/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValueAssert;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class TimerCatchEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final BpmnModelInstance SINGLE_TIMER_PROCESS = Bpmn.createExecutableProcess((String)"SINGLE_TIMER_PROCESS").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDuration("PT0.1S")).endEvent().done();
    private static final BpmnModelInstance BOUNDARY_EVENT_PROCESS = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"BOUNDARY_EVENT_PROCESS").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("timer").cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT1S")).endEvent("eventEnd").moveToActivity("task").endEvent("taskEnd").done();
    private static final BpmnModelInstance TWO_REPS_CYCLE_PROCESS = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"TWO_REPS_CYCLE_PROCESS").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("timer").cancelActivity(Boolean.valueOf(false))).timerWithCycle("R2/PT1S")).endEvent().moveToNode("task").endEvent().done();
    private static final BpmnModelInstance INFINITE_CYCLE_PROCESS = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"INFINITE_CYCLE_PROCESS").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("timer").cancelActivity(Boolean.valueOf(false))).timerWithCycle("R/PT1S")).endEvent().moveToNode("task").endEvent().done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        ENGINE.deployment().withXmlResource(SINGLE_TIMER_PROCESS).deploy();
        ENGINE.deployment().withXmlResource(BOUNDARY_EVENT_PROCESS).deploy();
        ENGINE.deployment().withXmlResource(TWO_REPS_CYCLE_PROCESS).deploy();
        ENGINE.deployment().withXmlResource(INFINITE_CYCLE_PROCESS).deploy();
    }

    @Test
    public void testLifeCycle() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"testLifeCycle").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDuration("PT0S")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("testLifeCycle").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementId("timer")).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ACTIVATE_ELEMENT, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.COMPLETE_ELEMENT, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).timerRecords()).extracting(Record::getIntent).containsSubsequence((Object[])new Intent[]{TimerIntent.CREATED, TimerIntent.TRIGGER, TimerIntent.TRIGGERED});
    }

    @Test
    public void shouldCreateTimer() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldCreateTimer").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDuration("PT10S")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldCreateTimer").create();
        Record activatedEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("timer").getFirst();
        Record createdEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)createdEvent.getValue())).hasElementInstanceKey(activatedEvent.getKey())).hasProcessInstanceKey(processInstanceKey);
        Assertions.assertThat((long)((TimerRecordValue)createdEvent.getValue()).getDueDate()).isBetween(Long.valueOf(ENGINE.getClock().getCurrentTimeInMillis()), Long.valueOf(createdEvent.getTimestamp() + Duration.ofSeconds(10L).toMillis()));
    }

    @Test
    public void shouldCreateTimerFromFeelExpression() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldCreateTimer").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDurationExpression("\"PT10S\"")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldCreateTimer").create();
        Record activatedEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("timer").getFirst();
        Record createdEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)createdEvent.getValue())).hasElementInstanceKey(activatedEvent.getKey())).hasProcessInstanceKey(processInstanceKey);
        Assertions.assertThat((long)((TimerRecordValue)createdEvent.getValue()).getDueDate()).isBetween(Long.valueOf(ENGINE.getClock().getCurrentTimeInMillis()), Long.valueOf(createdEvent.getTimestamp() + Duration.ofSeconds(10L).toMillis()));
    }

    @Test
    public void shouldTriggerTimer() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("SINGLE_TIMER_PROCESS").create();
        Record createdEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Record triggeredEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)triggeredEvent.getKey()).isEqualTo(createdEvent.getKey());
        Assertions.assertThat((Object)((TimerRecordValue)triggeredEvent.getValue())).isEqualTo((Object)createdEvent.getValue());
        Assertions.assertThat((Duration)Duration.ofMillis(triggeredEvent.getTimestamp() - createdEvent.getTimestamp())).isGreaterThanOrEqualTo((Comparable)Duration.ofSeconds(1L));
    }

    @Test
    public void shouldCompleteTimerEvent() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("SINGLE_TIMER_PROCESS").create();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Record activatedEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("timer").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        Record completedEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("timer").withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).getFirst();
        Assertions.assertThat((long)completedEvent.getKey()).isEqualTo(activatedEvent.getKey());
        Assertions.assertThat((Object)((ProcessInstanceRecordValue)completedEvent.getValue())).isEqualTo((Object)activatedEvent.getValue());
    }

    @Test
    public void shouldTriggerTimerWithZeroDuration() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldTriggerTimerWithZeroDuration").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDuration("PT0S")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldTriggerTimerWithZeroDuration").create();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessInstanceKey(processInstanceKey).exists()).isTrue();
    }

    @Test
    public void shouldTriggerTimerWithNegativeDuration() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldTriggerTimerWithNegativeDuration").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDuration("-PT1H")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldTriggerTimerWithNegativeDuration").create();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessInstanceKey(processInstanceKey).exists()).isTrue();
    }

    @Test
    public void shouldTriggerMultipleTimers() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldTriggerMultipleTimers").startEvent().parallelGateway().intermediateCatchEvent("timer1", c -> c.timerWithDuration("PT1S")).endEvent().moveToLastGateway().intermediateCatchEvent("timer2", c -> c.timerWithDuration("PT2S")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldTriggerMultipleTimers").create();
        Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).hasSize(2);
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Record triggeredTimer1 = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withHandlerNodeId("timer1").withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Record triggeredTimer2 = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withHandlerNodeId("timer2").withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.INTERMEDIATE_CATCH_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).limit(2L)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).contains((Object[])new String[]{"timer1", "timer2"});
        long timer1DueDate = ((TimerRecordValue)triggeredTimer1.getValue()).getDueDate();
        Assertions.assertThat((long)((TimerRecordValue)triggeredTimer2.getValue()).getDueDate()).isBetween(Long.valueOf(timer1DueDate), Long.valueOf(timer1DueDate + Duration.ofSeconds(1L).toMillis()));
    }

    @Test
    public void shouldCancelTimer() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"shouldCancelTimer").startEvent().intermediateCatchEvent("timer", c -> c.timerWithDuration("PT10S")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldCancelTimer").create();
        Record createdEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).withHandlerNodeId("timer").getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record canceledEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)canceledEvent.getKey()).isEqualTo(createdEvent.getKey());
        Assertions.assertThat((Object)((TimerRecordValue)canceledEvent.getValue())).isEqualTo((Object)createdEvent.getValue());
    }

    @Test
    public void shouldCreateTimerBasedOnBoundaryEvent() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("BOUNDARY_EVENT_PROCESS").create();
        Record timerRecord = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record activityRecord = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        ((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)timerRecord.getValue())).hasElementInstanceKey(activityRecord.getKey())).hasTargetElementId("timer");
        Assertions.assertThat((long)((TimerRecordValue)timerRecord.getValue()).getDueDate()).isBetween(Long.valueOf(ENGINE.getClock().getCurrentTimeInMillis()), Long.valueOf(timerRecord.getTimestamp() + Duration.ofSeconds(1L).toMillis()));
    }

    @Test
    public void shouldTriggerHandlerNodeWhenAttachedToActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("BOUNDARY_EVENT_PROCESS").create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Record timerTriggered = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)timerTriggered.getKey()).isEqualTo(timerCreated.getKey());
        Assertions.assertThat((Object)((TimerRecordValue)timerTriggered.getValue())).isEqualTo((Object)timerCreated.getValue());
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETING).withProcessInstanceKey(processInstanceKey).withElementId("timer").exists()).isTrue();
    }

    @Test
    public void shouldRecreateTimerWithCycle() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("TWO_REPS_CYCLE_PROCESS").create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Record timerRescheduled = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).getLast();
        Assertions.assertThat((long)timerRescheduled.getKey()).isGreaterThan(timerCreated.getKey());
        ((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)timerRescheduled.getValue())).hasTargetElementId(((TimerRecordValue)timerCreated.getValue()).getTargetElementId())).hasElementInstanceKey(((TimerRecordValue)timerCreated.getValue()).getElementInstanceKey());
        Assertions.assertThat((long)((TimerRecordValue)timerRescheduled.getValue()).getDueDate()).isGreaterThanOrEqualTo(((TimerRecordValue)timerCreated.getValue()).getDueDate() + Duration.ofSeconds(1L).toMillis());
    }

    @Test
    public void shouldRecreateTimerForTheSpecifiedAmountOfRepetitions() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"shouldRecreateTimerForTheSpecifiedAmountOfRepetitions").startEvent().parallelGateway("gw").serviceTask("task-1", b -> b.zeebeJobType("type")).boundaryEvent("timer-1").cancelActivity(Boolean.valueOf(false))).timerWithCycle("R1/PT1S")).endEvent().moveToNode("gw").serviceTask("task-2", b -> b.zeebeJobType("type")).boundaryEvent("timer-2").cancelActivity(Boolean.valueOf(false))).timerWithCycle("R3/PT1S")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldRecreateTimerForTheSpecifiedAmountOfRepetitions").create();
        Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).hasSize(2);
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(3L)).hasSize(3);
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(4L)).hasSize(4)).extracting(r -> ((TimerRecordValue)r.getValue()).getTargetElementId()).containsExactlyInAnyOrder((Object[])new String[]{"timer-1", "timer-2", "timer-2", "timer-2"});
    }

    @Test
    public void shouldRecreateTimerInfinitely() {
        int expectedRepetitions = 10;
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("INFINITE_CYCLE_PROCESS").create();
        IntStream.range(1, 11).forEach(i -> {
            ((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit((long)i)).count();
            ENGINE.increaseTime(Duration.ofSeconds(1L));
        });
        Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(10L)).hasSize(10);
        Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessInstanceKey(processInstanceKey).limit(10L)).hasSize(10);
    }

    @Test
    public void shouldHaveNoSourceRecordPositionOnTimerTrigger() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)"process1");
        ((StartEventBuilder)((StartEventBuilder)process.eventSubProcess("eventSub").startEvent().interrupting(true)).timerWithDuration("PT15S")).endEvent();
        BpmnModelInstance modelInstance = ((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)process.startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("foo < 5")).endEvent().done();
        ENGINE.deployment().withXmlResource(modelInstance).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process1").create();
        ((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).await();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("eventSub").withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withElementType(BpmnElementType.EVENT_SUB_PROCESS).await();
        Record triggerTimer = (Record)((TimerRecordStream)RecordingExporter.timerRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)TimerIntent.TRIGGER)).getFirst();
        Assertions.assertThat((long)triggerTimer.getSourceRecordPosition()).isLessThan(0L);
    }
}

