/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public final class TimerStartEventTest {
    private static final BpmnModelInstance SIMPLE_MODEL = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_1").timerWithCycle("R1/PT1S")).endEvent("end_1").done();
    private static final BpmnModelInstance REPEATING_MODEL = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_2").timerWithCycle("R/PT1S")).endEvent("end_2").done();
    private static final BpmnModelInstance THREE_SEC_MODEL = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process_3").startEvent("start_3").timerWithCycle("R2/PT3S")).endEvent("end_3").done();
    private static final BpmnModelInstance MULTIPLE_START_EVENTS_MODEL = TimerStartEventTest.createTimerAndMessageStartEventsModel();
    private static final BpmnModelInstance MULTI_TIMER_START_MODEL = TimerStartEventTest.createMultipleTimerStartModel();
    private static final BpmnModelInstance FEEL_DATE_TIME_EXPRESSION_MODEL = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process_5").startEvent("start_5").timerWithDateExpression("date and time(date(\"3978-11-25\"),time(\"T00:00:00@UTC\"))")).endEvent("end_5").done();
    private static final BpmnModelInstance FEEL_CYCLE_EXPRESSION_MODEL = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process_5").startEvent("start_6").timerWithCycleExpression("cycle(duration(\"PT1S\"))")).endEvent("end_6").done();
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    private static BpmnModelInstance createTimerAndMessageStartEventsModel() {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)"process");
        builder.startEvent("none_start").endEvent("none_end");
        ((StartEventBuilder)builder.startEvent("timer_start").timerWithCycle("R1/PT1S")).endEvent("timer_end");
        return ((StartEventBuilder)builder.startEvent("msg_start").message("msg1")).endEvent("msg_end").done();
    }

    private static BpmnModelInstance createMultipleTimerStartModel() {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)"process_4");
        ((StartEventBuilder)builder.startEvent("start_4").timerWithCycle("R/PT2S")).endEvent("end_4");
        return ((StartEventBuilder)builder.startEvent("start_4_2").timerWithCycle("R/PT3S")).endEvent("end_4_2").done();
    }

    @Test
    public void shouldCreateTimer() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(SIMPLE_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst()).getValue();
        ((TimerRecordValueAssert)((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)timerRecord).hasProcessInstanceKey(-1L)).hasTargetElementId("start_1")).hasElementInstanceKey(-1L);
        long now = this.engine.getClock().getCurrentTimeInMillis();
        Assertions.assertThat((long)timerRecord.getDueDate()).isBetween(Long.valueOf(now), Long.valueOf(now + 1000L));
    }

    @Test
    public void shouldCreateTimerFromFeelExpression() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(FEEL_DATE_TIME_EXPRESSION_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst()).getValue();
        ((TimerRecordValueAssert)((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)timerRecord).hasProcessInstanceKey(-1L)).hasTargetElementId("start_5")).hasElementInstanceKey(-1L);
        long expected = ZonedDateTime.of(LocalDate.of(3978, 11, 25), LocalTime.of(0, 0, 0), ZoneId.of("UTC")).toInstant().toEpochMilli();
        Assertions.assertThat((long)timerRecord.getDueDate()).isEqualTo(expected);
    }

    @Test
    public void shouldNotReCreateTimerOnDuplicateDeployment() {
        BpmnModelInstance firstVersion = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_5").timerWithDateExpression("now() + duration(\"PT15S\")")).endEvent("end_5").done();
        BpmnModelInstance secondVersion = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_6").timerWithDateExpression("now() + duration(\"PT15S\")")).endEvent("end_5").done();
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(firstVersion).deploy().getValue()).getProcessesMetadata().get(0);
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst()).getValue();
        this.engine.deployment().withXmlResource(firstVersion).deploy();
        ProcessMetadataValue secondVersionMetadata = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(secondVersion).deploy().getValue()).getProcessesMetadata().get(0);
        long actualTimerCount = ((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).limit(timerRecordValueRecord -> ((TimerRecordValue)timerRecordValueRecord.getValue()).getProcessDefinitionKey() == secondVersionMetadata.getProcessDefinitionKey())).count();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTimerCount).describedAs("Timer.CREATED count should be %d, but was %d", new Object[]{2, actualTimerCount})).isEqualTo(2L);
    }

    @Test
    public void shouldNotReTriggerTimerAfterDuplicateDeployment() {
        BpmnModelInstance firstVersion = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_5").timerWithDateExpression("now() + duration(\"PT15S\")")).endEvent("end_5").done();
        BpmnModelInstance secondVersion = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_6").timerWithDateExpression("now() + duration(\"PT15S\")")).endEvent("end_5").done();
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(firstVersion).deploy().getValue()).getProcessesMetadata().get(0);
        this.engine.awaitProcessingOf((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst());
        this.engine.increaseTime(Duration.ofMinutes(1L));
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).await();
        this.engine.deployment().withXmlResource(firstVersion).deploy();
        this.engine.increaseTime(Duration.ofMinutes(1L));
        ProcessMetadataValue secondVersionMetadata = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(secondVersion).deploy().getValue()).getProcessesMetadata().get(0);
        this.engine.awaitProcessingOf((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(secondVersionMetadata.getProcessDefinitionKey()).getFirst());
        this.engine.increaseTime(Duration.ofMinutes(1L));
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).withProcessDefinitionKey(secondVersionMetadata.getProcessDefinitionKey()).await();
        List processInstanceRecords = (List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().limit(record -> record.getIntent() == ProcessInstanceIntent.ACTIVATE_ELEMENT && ((ProcessInstanceRecordValue)record.getValue()).getProcessDefinitionKey() == secondVersionMetadata.getProcessDefinitionKey())).collect(Collectors.toList());
        List processInstanceActivateList = processInstanceRecords.stream().filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType() == BpmnElementType.PROCESS).filter(record -> record.getIntent() == ProcessInstanceIntent.ACTIVATE_ELEMENT).collect(Collectors.toList());
        ((ListAssert)((ListAssert)Assertions.assertThat(processInstanceActivateList).describedAs("Expect to trigger timer start events only for new deployments, but duplicate deployment causes retriggering of timer start event.", new Object[0])).hasSize(2)).extracting(record -> ((ProcessInstanceRecordValue)record.getValue()).getProcessDefinitionKey()).containsExactly((Object[])new Long[]{deployedProcess.getProcessDefinitionKey(), secondVersionMetadata.getProcessDefinitionKey()});
    }

    @Test
    public void shouldCreateRepeatingTimerFromFeelExpression() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(FEEL_CYCLE_EXPRESSION_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst()).getValue();
        ((TimerRecordValueAssert)((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)timerRecord).hasProcessInstanceKey(-1L)).hasTargetElementId("start_6")).hasElementInstanceKey(-1L);
        long now = this.engine.getClock().getCurrentTimeInMillis();
        Assertions.assertThat((long)timerRecord.getDueDate()).isBetween(Long.valueOf(now), Long.valueOf(now + 10000L));
    }

    @Test
    public void shouldTriggerAndCreateProcessInstance() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(SIMPLE_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        long processDefinitionKey = deployedProcess.getProcessDefinitionKey();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(2L));
        ProcessInstanceRecordValue startEventActivating = (ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementType(BpmnElementType.START_EVENT).withProcessDefinitionKey(processDefinitionKey).getFirst()).getValue();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)startEventActivating).hasElementId("start_1")).hasBpmnProcessId("process")).hasVersion(deployedProcess.getVersion())).hasProcessDefinitionKey(processDefinitionKey);
        long triggerRecordPosition = ((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).withProcessDefinitionKey(processDefinitionKey).getFirst()).getPosition();
        Assertions.assertThat((Stream)((TimerRecordStream)RecordingExporter.timerRecords().withProcessDefinitionKey(processDefinitionKey).skipUntil(r -> r.getPosition() >= triggerRecordPosition)).limit(2L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{TimerIntent.TRIGGER, TimerIntent.TRIGGERED});
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessDefinitionKey(processDefinitionKey).skipUntil(r -> r.getPosition() >= triggerRecordPosition)).limit(4L)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING})});
    }

    @Test
    public void shouldCreateMultipleProcessInstancesWithRepeatingTimer() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(THREE_SEC_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        long processDefinitionKey = deployedProcess.getProcessDefinitionKey();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(3L));
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(processDefinitionKey).exists()).isTrue();
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("process_3").withProcessDefinitionKey(processDefinitionKey).exists()).isTrue();
        Assertions.assertThat((long)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).limit(2L)).count()).isEqualTo(2L);
        this.engine.increaseTime(Duration.ofSeconds(3L));
        Assertions.assertThat((long)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(processDefinitionKey).limit(2L)).count()).isEqualTo(2L);
        Assertions.assertThat((long)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("process_3").withProcessDefinitionKey(processDefinitionKey).limit(2L)).count()).isEqualTo(2L);
    }

    @Test
    public void shouldCompleteProcess() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(SIMPLE_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(1L));
        ProcessInstanceRecordValue instanceCompleted = (ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).withElementId("process").getFirst()).getValue();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)instanceCompleted).hasBpmnProcessId("process")).hasVersion(1)).hasProcessDefinitionKey(deployedProcess.getProcessDefinitionKey());
    }

    @Test
    public void shouldUpdateProcess() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(SIMPLE_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("end_1").withBpmnProcessId("process").withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).withVersion(1).exists()).isTrue();
        ProcessMetadataValue repeatingProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(REPEATING_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(repeatingProcess.getProcessDefinitionKey()).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(2L));
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("end_2").withBpmnProcessId("process").withProcessDefinitionKey(repeatingProcess.getProcessDefinitionKey()).withVersion(2).exists()).isTrue();
    }

    @Test
    public void shouldReplaceTimerStartWithNoneStart() {
        ProcessMetadataValue repeatingProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(REPEATING_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        long repeatingProcessDefinitionKey = repeatingProcess.getProcessDefinitionKey();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(repeatingProcessDefinitionKey).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(repeatingProcessDefinitionKey).exists()).isTrue();
        BpmnModelInstance nonTimerModel = Bpmn.createExecutableProcess((String)"process").startEvent("start_4").endEvent("end_4").done();
        ProcessMetadataValue notTimerDeployment = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(nonTimerModel).deploy().getValue()).getProcessesMetadata().get(0);
        this.engine.increaseTime(Duration.ofSeconds(2L));
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(repeatingProcessDefinitionKey).exists()).isTrue();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(repeatingProcessDefinitionKey).exists()).isTrue();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId("process").create();
        ProcessInstanceRecordValue lastRecord = (ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("end_4").withProcessDefinitionKey(notTimerDeployment.getProcessDefinitionKey()).getFirst()).getValue();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)lastRecord).hasVersion(2)).hasBpmnProcessId("process")).hasProcessInstanceKey(processInstanceKey);
    }

    @Test
    public void shouldUpdateTimerPeriod() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(THREE_SEC_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        long processDefinitionKey = deployedProcess.getProcessDefinitionKey();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).exists()).isTrue();
        long now = this.engine.getClock().getCurrentTimeInMillis();
        this.engine.increaseTime(Duration.ofSeconds(3L));
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(processDefinitionKey).getFirst()).getValue();
        Assertions.assertThat((long)timerRecord.getDueDate()).isBetween(Long.valueOf(now), Long.valueOf(now + 3000L));
        BpmnModelInstance slowerModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process_3").startEvent("start_4").timerWithCycle("R2/PT4S")).endEvent("end_4").done();
        ProcessMetadataValue slowerDeployment = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(slowerModel).deploy().getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((Object)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(processDefinitionKey).getFirst())).isNotNull();
        Record slowTimerRecord = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(slowerDeployment.getProcessDefinitionKey()).getFirst();
        timerRecord = (TimerRecordValue)slowTimerRecord.getValue();
        long writtenTime = slowTimerRecord.getTimestamp();
        Assertions.assertThat((long)timerRecord.getDueDate()).isBetween(Long.valueOf(writtenTime), Long.valueOf(writtenTime + 4000L));
        this.engine.increaseTime(Duration.ofSeconds(4L));
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(slowerDeployment.getProcessDefinitionKey()).exists()).isTrue();
    }

    @Test
    public void shouldTriggerDifferentProcessesSeparately() {
        ProcessMetadataValue firstDeployment = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(THREE_SEC_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        ProcessMetadataValue secondDeployment = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(REPEATING_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(firstDeployment.getProcessDefinitionKey()).exists()).isTrue();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(secondDeployment.getProcessDefinitionKey()).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(1L));
        long firstModelTimestamp = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("process").getFirst()).getTimestamp();
        this.engine.increaseTime(Duration.ofSeconds(2L));
        Assertions.assertThat((long)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("process").withProcessDefinitionKey(secondDeployment.getProcessDefinitionKey()).limit(2L)).count()).isEqualTo(2L);
        long secondModelTimestamp = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId("process_3").withProcessDefinitionKey(firstDeployment.getProcessDefinitionKey()).getFirst()).getTimestamp();
        Assertions.assertThat((long)secondModelTimestamp).isGreaterThan(firstModelTimestamp);
    }

    @Test
    public void shouldCreateMultipleInstanceAtTheCorrectTimes() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(MULTI_TIMER_START_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((long)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).limit(2L)).count()).isEqualTo(2L);
        this.engine.increaseTime(Duration.ofSeconds(2L));
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withElementId("end_4").withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).exists()).isTrue();
        this.engine.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withElementId("end_4_2").withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).exists()).isTrue();
    }

    @Test
    public void shouldTriggerAtSpecifiedTimeDate() {
        Instant triggerTime = Instant.now().plusMillis(2000L);
        BpmnModelInstance model = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_2").timerWithDate(triggerTime.toString())).endEvent("end_2").done();
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(model).deploy().getValue()).getProcessesMetadata().get(0);
        this.engine.increaseTime(Duration.ofSeconds(2L));
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst()).getValue();
        ((TimerRecordValueAssert)((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)timerRecord).hasDueDate(triggerTime.toEpochMilli())).hasTargetElementId("start_2")).hasElementInstanceKey(-1L);
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("end_2").withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).exists()).isTrue();
    }

    @Test
    public void shouldTriggerIfTimeDatePassedOnDeployment() {
        Instant triggerTime = Instant.now().plusMillis(2000L);
        BpmnModelInstance model = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start_2").timerWithDate(triggerTime.toString())).endEvent("end_2").done();
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(model).deploy().getValue()).getProcessesMetadata().get(0);
        this.engine.increaseTime(Duration.ofMillis(2000L));
        TimerRecordValue timerRecord = (TimerRecordValue)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).getFirst()).getValue();
        ((TimerRecordValueAssert)((TimerRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)timerRecord).hasDueDate(triggerTime.toEpochMilli())).hasTargetElementId("start_2")).hasElementInstanceKey(-1L);
    }

    @Test
    public void shouldTriggerOnlyTimerStartEvent() {
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(MULTIPLE_START_EVENTS_MODEL).deploy().getValue()).getProcessesMetadata().get(0);
        long processDefinitionKey = deployedProcess.getProcessDefinitionKey();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).await();
        this.engine.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessDefinitionKey(processDefinitionKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"timer_start"});
    }
}

